/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.glue.model.Table;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.ForRecordingHiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.RecordingHiveMetastoreModule;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreModule;
import io.trino.plugin.hive.metastore.glue.DefaultGlueMetastoreTableFilterProvider;
import io.trino.plugin.hive.metastore.glue.DisabledGlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import org.weakref.jmx.guice.ExportBinder;

public class GlueMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(GlueHiveMetastoreConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, GlueColumnStatisticsProvider.class).setDefault().to(DisabledGlueColumnStatisticsProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(RequestHandler2.class, ForGlueHiveMetastore.class));
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get((TypeLiteral)new TypeLiteral<Predicate<Table>>(){}, ForGlueHiveMetastore.class)).setDefault().toProvider(DefaultGlueMetastoreTableFilterProvider.class).in(Scopes.SINGLETON);
        binder.bind(HiveMetastore.class).annotatedWith(ForRecordingHiveMetastore.class).to(GlueHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(GlueHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(GlueHiveMetastore.class).withGeneratedName();
        this.install((Module)new RecordingHiveMetastoreModule());
        this.install(new CachingHiveMetastoreModule());
    }

    @Provides
    @Singleton
    @ForGlueHiveMetastore
    public Executor createExecutor(CatalogName catalogName, GlueHiveMetastoreConfig hiveConfig) {
        if (hiveConfig.getGetPartitionThreads() == 1) {
            return MoreExecutors.directExecutor();
        }
        return new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-glue-%s")), hiveConfig.getGetPartitionThreads());
    }
}

