/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.util.Memoizers;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.PrincipalType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.hadoop.hive.metastore.TableType;

public final class GlueToTrinoConverter {
    private static final String PUBLIC_OWNER = "PUBLIC";

    private GlueToTrinoConverter() {
    }

    public static Database convertDatabase(com.amazonaws.services.glue.model.Database glueDb) {
        return Database.builder().setDatabaseName(glueDb.getName()).setLocation(Optional.ofNullable(glueDb.getLocationUri())).setComment(Optional.ofNullable(glueDb.getDescription())).setParameters((Map)MoreObjects.firstNonNull((Object)glueDb.getParameters(), (Object)ImmutableMap.of())).setOwnerName(PUBLIC_OWNER).setOwnerType(PrincipalType.ROLE).build();
    }

    public static Table convertTable(com.amazonaws.services.glue.model.Table glueTable, String dbName) {
        Objects.requireNonNull(glueTable.getStorageDescriptor(), "Table StorageDescriptor is null");
        Map<String, String> tableParameters = GlueToTrinoConverter.convertParameters(glueTable.getParameters());
        StorageDescriptor sd = glueTable.getStorageDescriptor();
        Table.Builder tableBuilder = Table.builder().setDatabaseName(dbName).setTableName(glueTable.getName()).setOwner(Strings.nullToEmpty((String)glueTable.getOwner())).setTableType((String)MoreObjects.firstNonNull((Object)glueTable.getTableType(), (Object)TableType.EXTERNAL_TABLE.name())).setDataColumns(GlueToTrinoConverter.convertColumns(sd.getColumns())).setParameters(tableParameters).setViewOriginalText(Optional.ofNullable(glueTable.getViewOriginalText())).setViewExpandedText(Optional.ofNullable(glueTable.getViewExpandedText()));
        if (glueTable.getPartitionKeys() != null) {
            tableBuilder.setPartitionColumns(GlueToTrinoConverter.convertColumns(glueTable.getPartitionKeys()));
        } else {
            tableBuilder.setPartitionColumns((List<Column>)ImmutableList.of());
        }
        new StorageConverter().setStorageBuilder(sd, tableBuilder.getStorageBuilder(), tableParameters);
        return tableBuilder.build();
    }

    private static Column convertColumn(com.amazonaws.services.glue.model.Column glueColumn) {
        return new Column(glueColumn.getName(), HiveType.valueOf(glueColumn.getType().toLowerCase(Locale.ENGLISH)), Optional.ofNullable(glueColumn.getComment()));
    }

    private static List<Column> convertColumns(List<com.amazonaws.services.glue.model.Column> glueColumns) {
        return GlueToTrinoConverter.mappedCopy(glueColumns, GlueToTrinoConverter::convertColumn);
    }

    private static Map<String, String> convertParameters(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(parameters);
    }

    private static Function<Map<String, String>, Map<String, String>> parametersConverter() {
        return Memoizers.memoizeLast(GlueToTrinoConverter::convertParameters);
    }

    private static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static <T, R> List<R> mappedCopy(List<T> list, Function<T, R> mapper) {
        Objects.requireNonNull(list, "list is null");
        Objects.requireNonNull(mapper, "mapper is null");
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (T item : list) {
            builder.add(mapper.apply(item));
        }
        return builder.build();
    }

    private static final class StorageFormatConverter {
        private static final StorageFormat ALL_NULLS = StorageFormat.createNullable(null, null, null);
        private final UnaryOperator<String> serializationLib = Memoizers.memoizeLast();
        private final UnaryOperator<String> inputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<String> outputFormat = Memoizers.memoizeLast();
        private final UnaryOperator<StorageFormat> storageFormat = Memoizers.memoizeLast();

        private StorageFormatConverter() {
        }

        public StorageFormat createStorageFormat(SerDeInfo serdeInfo, StorageDescriptor storageDescriptor) {
            String serializationLib = (String)this.serializationLib.apply(serdeInfo.getSerializationLibrary());
            String inputFormat = (String)this.inputFormat.apply(storageDescriptor.getInputFormat());
            String outputFormat = (String)this.outputFormat.apply(storageDescriptor.getOutputFormat());
            if (serializationLib == null && inputFormat == null && outputFormat == null) {
                return ALL_NULLS;
            }
            return (StorageFormat)this.storageFormat.apply(StorageFormat.createNullable(serializationLib, inputFormat, outputFormat));
        }
    }

    private static final class StorageConverter {
        private final Function<List<String>, List<String>> bucketColumns = Memoizers.memoizeLast(ImmutableList::copyOf);
        private final Function<List<Order>, List<SortingColumn>> sortColumns = Memoizers.memoizeLast(StorageConverter::createSortingColumns);
        private final UnaryOperator<Optional<HiveBucketProperty>> bucketProperty = Memoizers.memoizeLast();
        private final Function<Map<String, String>, Map<String, String>> serdeParametersConverter = GlueToTrinoConverter.parametersConverter();
        private final StorageFormatConverter storageFormatConverter = new StorageFormatConverter();

        private StorageConverter() {
        }

        public void setStorageBuilder(StorageDescriptor sd, Storage.Builder storageBuilder, Map<String, String> tableParameters) {
            Objects.requireNonNull(sd.getSerdeInfo(), "StorageDescriptor SerDeInfo is null");
            SerDeInfo serdeInfo = sd.getSerdeInfo();
            storageBuilder.setStorageFormat(this.storageFormatConverter.createStorageFormat(serdeInfo, sd)).setLocation(Strings.nullToEmpty((String)sd.getLocation())).setBucketProperty(this.convertToBucketProperty(tableParameters, sd)).setSkewed(sd.getSkewedInfo() != null && !GlueToTrinoConverter.isNullOrEmpty(sd.getSkewedInfo().getSkewedColumnNames())).setSerdeParameters(this.serdeParametersConverter.apply(serdeInfo.getParameters())).build();
        }

        private Optional<HiveBucketProperty> convertToBucketProperty(Map<String, String> tableParameters, StorageDescriptor sd) {
            if (sd.getNumberOfBuckets() > 0) {
                if (GlueToTrinoConverter.isNullOrEmpty(sd.getBucketColumns())) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set");
                }
                List<String> bucketColumns = this.bucketColumns.apply(sd.getBucketColumns());
                List<SortingColumn> sortedBy = this.sortColumns.apply(sd.getSortColumns());
                HiveBucketing.BucketingVersion bucketingVersion = HiveBucketing.getBucketingVersion(tableParameters);
                return (Optional)this.bucketProperty.apply(Optional.of(new HiveBucketProperty(bucketColumns, bucketingVersion, sd.getNumberOfBuckets(), sortedBy)));
            }
            return Optional.empty();
        }

        private static List<SortingColumn> createSortingColumns(List<Order> sortColumns) {
            if (GlueToTrinoConverter.isNullOrEmpty(sortColumns)) {
                return ImmutableList.of();
            }
            return GlueToTrinoConverter.mappedCopy(sortColumns, column -> new SortingColumn(column.getColumn(), SortingColumn.Order.fromMetastoreApiOrder(column.getSortOrder(), "unknown")));
        }
    }

    public static final class GluePartitionConverter
    implements Function<com.amazonaws.services.glue.model.Partition, Partition> {
        private final Function<List<com.amazonaws.services.glue.model.Column>, List<Column>> columnsConverter = Memoizers.memoizeLast(x$0 -> GlueToTrinoConverter.convertColumns(x$0));
        private final Function<Map<String, String>, Map<String, String>> parametersConverter = GlueToTrinoConverter.parametersConverter();
        private final StorageConverter storageConverter = new StorageConverter();
        private final String databaseName;
        private final String tableName;
        private final Map<String, String> tableParameters;

        public GluePartitionConverter(Table table) {
            Objects.requireNonNull(table, "table is null");
            this.databaseName = Objects.requireNonNull(table.getDatabaseName(), "databaseName is null");
            this.tableName = Objects.requireNonNull(table.getTableName(), "tableName is null");
            this.tableParameters = GlueToTrinoConverter.convertParameters(table.getParameters());
        }

        @Override
        public Partition apply(com.amazonaws.services.glue.model.Partition gluePartition) {
            Objects.requireNonNull(gluePartition.getStorageDescriptor(), "Partition StorageDescriptor is null");
            StorageDescriptor sd = gluePartition.getStorageDescriptor();
            if (!this.databaseName.equals(gluePartition.getDatabaseName())) {
                throw new IllegalArgumentException(String.format("Unexpected databaseName, expected: %s, but found: %s", this.databaseName, gluePartition.getDatabaseName()));
            }
            if (!this.tableName.equals(gluePartition.getTableName())) {
                throw new IllegalArgumentException(String.format("Unexpected tableName, expected: %s, but found: %s", this.tableName, gluePartition.getTableName()));
            }
            Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(this.databaseName).setTableName(this.tableName).setValues(gluePartition.getValues()).setColumns(this.columnsConverter.apply(sd.getColumns())).setParameters(this.parametersConverter.apply(gluePartition.getParameters()));
            this.storageConverter.setStorageBuilder(sd, partitionBuilder.getStorageBuilder(), this.tableParameters);
            return partitionBuilder.build();
        }
    }
}

