/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.net.URI;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.validation.constraints.NotNull;

public class StaticMetastoreConfig {
    public static final String HIVE_METASTORE_USERNAME = "hive.metastore.username";
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<URI> metastoreUris;
    private String metastoreUsername;

    @NotNull
    public List<URI> getMetastoreUris() {
        return this.metastoreUris;
    }

    @Config(value="hive.metastore.uri")
    @ConfigDescription(value="Hive metastore URIs (comma separated)")
    public StaticMetastoreConfig setMetastoreUris(String uris) {
        if (uris == null) {
            this.metastoreUris = null;
            return this;
        }
        this.metastoreUris = (List)StreamSupport.stream(SPLITTER.split((CharSequence)uris).spliterator(), false).map(URI::create).collect(ImmutableList.toImmutableList());
        return this;
    }

    public String getMetastoreUsername() {
        return this.metastoreUsername;
    }

    @Config(value="hive.metastore.username")
    @ConfigDescription(value="Optional username for accessing the Hive metastore")
    public StaticMetastoreConfig setMetastoreUsername(String metastoreUsername) {
        this.metastoreUsername = metastoreUsername;
        return this;
    }
}

