/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableMap;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidSchema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.orc.OrcConf;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class OrcFileWriterFactory
implements HiveFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats readStats;
    private final OrcWriterStats stats = new OrcWriterStats();
    private final OrcWriterOptions orcWriterOptions;
    private final boolean writeLegacyVersion;

    @Inject
    public OrcFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, OrcWriterConfig orcWriterConfig, FileFormatDataSourceStats readStats, OrcWriterConfig config) {
        this(hdfsEnvironment, typeManager, nodeVersion, Objects.requireNonNull(orcWriterConfig, "orcWriterConfig is null").isUseLegacyVersion(), readStats, Objects.requireNonNull(config, "config is null").toOrcWriterOptions());
    }

    public OrcFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, boolean writeLegacyVersion, FileFormatDataSourceStats readStats, OrcWriterOptions orcWriterOptions) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.writeLegacyVersion = writeLegacyVersion;
        this.readStats = Objects.requireNonNull(readStats, "stats is null");
        this.orcWriterOptions = Objects.requireNonNull(orcWriterOptions, "orcWriterOptions is null");
    }

    @Managed
    @Flatten
    public OrcWriterStats getStats() {
        return this.stats;
    }

    @Override
    public Optional<FileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session, OptionalInt bucketNumber, AcidTransaction transaction, boolean useAcidSchema, WriterKind writerKind) {
        if (!OrcOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        CompressionKind compression = OrcFileWriterFactory.getCompression(schema, configuration);
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<Type> fileColumnTypes = HiveUtil.getColumnTypes(schema).stream().map(hiveType -> hiveType.getType(this.typeManager, HiveSessionProperties.getTimestampPrecision(session))).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        if (transaction.isAcidDeleteOperation(writerKind)) {
            fileInputColumnIndexes[fileInputColumnIndexes.length - 1] = -1;
        }
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, (Configuration)configuration);
            OrcDataSink orcDataSink = OrcFileWriterFactory.createOrcDataSink(fileSystem, path);
            Optional<Supplier<OrcDataSource>> validationInputFactory = Optional.empty();
            if (HiveSessionProperties.isOrcOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> {
                    try {
                        return new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSystem.getFileStatus(path).getLen(), new OrcReaderOptions(), fileSystem.open(path), this.readStats);
                    }
                    catch (IOException e) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
                    }
                });
            }
            Callable<Void> rollbackAction = () -> {
                fileSystem.delete(path, false);
                return null;
            };
            if (transaction.isInsert() && useAcidSchema) {
                Type rowType = AcidSchema.createRowType(fileColumnNames, fileColumnTypes);
                fileColumnNames = AcidSchema.ACID_COLUMN_NAMES;
                fileColumnTypes = AcidSchema.createAcidColumnPrestoTypes(rowType);
            }
            return Optional.of(new OrcFileWriter(orcDataSink, writerKind, transaction, useAcidSchema, bucketNumber, rollbackAction, fileColumnNames, fileColumnTypes, (ColumnMetadata<OrcType>)OrcType.createRootOrcType(fileColumnNames, fileColumnTypes), compression, HiveUtil.getOrcWriterOptions(schema, this.orcWriterOptions).withStripeMinSize(HiveSessionProperties.getOrcOptimizedWriterMinStripeSize(session)).withStripeMaxSize(HiveSessionProperties.getOrcOptimizedWriterMaxStripeSize(session)).withStripeMaxRowCount(HiveSessionProperties.getOrcOptimizedWriterMaxStripeRows(session)).withDictionaryMaxMemory(HiveSessionProperties.getOrcOptimizedWriterMaxDictionaryMemory(session)).withMaxStringStatisticsLimit(HiveSessionProperties.getOrcStringStatisticsLimit(session)), this.writeLegacyVersion, fileInputColumnIndexes, (Map<String, String>)ImmutableMap.builder().put((Object)"presto_version", (Object)this.nodeVersion.toString()).put((Object)"presto_query_id", (Object)session.getQueryId()).build(), validationInputFactory, HiveSessionProperties.getOrcOptimizedWriterValidateMode(session), this.stats));
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating ORC file", (Throwable)e);
        }
    }

    public static OrcDataSink createOrcDataSink(FileSystem fileSystem, Path path) throws IOException {
        return new OutputStreamOrcDataSink((OutputStream)fileSystem.create(path));
    }

    private static CompressionKind getCompression(Properties schema, JobConf configuration) {
        CompressionKind compression;
        String compressionName = OrcConf.COMPRESS.getString(schema, (Configuration)configuration);
        if (compressionName == null) {
            return CompressionKind.ZLIB;
        }
        try {
            compression = CompressionKind.valueOf((String)compressionName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Unknown ORC compression type " + compressionName);
        }
        return compression;
    }
}

