/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.Field;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private final List<Type> types;
    private final List<Optional<Field>> fields;
    private int batchId;
    private boolean closed;

    public ParquetPageSource(ParquetReader parquetReader, List<Type> types, List<Optional<Field>> fields) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.fields = ImmutableList.copyOf((Collection)Objects.requireNonNull(fields, "fields is null"));
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getSystemMemoryUsage() {
        return this.parquetReader.getSystemMemoryContext().getBytes();
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            int batchSize = this.parquetReader.nextBatch();
            if (this.closed || batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.fields.size()];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Optional<Field> field = this.fields.get(fieldId);
                blocks[fieldId] = field.isPresent() ? new LazyBlock(batchSize, (LazyBlockLoader)new ParquetBlockLoader(field.get())) : RunLengthEncodedBlock.create((Type)this.types.get(fieldId), null, (int)batchSize);
            }
            return new Page(batchSize, blocks);
        }
        catch (TrinoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader {
        private final int expectedBatchId;
        private final Field field;
        private boolean loaded;

        public ParquetBlockLoader(Field field) {
            this.expectedBatchId = ParquetPageSource.this.batchId;
            this.field = Objects.requireNonNull(field, "field is null");
        }

        public final Block load() {
            Block block;
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((ParquetPageSource.this.batchId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                block = ParquetPageSource.this.parquetReader.readBlock(this.field);
            }
            catch (ParquetCorruptionException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
            return block;
        }
    }
}

