/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.parquet.Field;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.parquet.HdfsParquetDataSource;
import io.trino.plugin.hive.parquet.ParquetColumnIOConverter;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class ParquetPageSourceFactory
implements HivePageSourceFactory {
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final ParquetReaderOptions options;
    private final DateTimeZone timeZone;

    @Inject
    public ParquetPageSourceFactory(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, ParquetReaderConfig config, HiveConfig hiveConfig) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(config, "config is null");
        this.options = config.toParquetReaderOptions();
        this.timeZone = Objects.requireNonNull(hiveConfig, "hiveConfig is null").getParquetDateTimeZone();
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        if (!PARQUET_SERDE_CLASS_NAMES.contains(HiveUtil.getDeserializerClassName(schema))) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
        return Optional.of(ParquetPageSourceFactory.createPageSource(path, start, length, estimatedFileSize, columns, effectivePredicate, HiveSessionProperties.isUseParquetColumnNames(session), this.hdfsEnvironment, configuration, session.getUser(), this.timeZone, this.stats, this.options.withIgnoreStatistics(HiveSessionProperties.isParquetIgnoreStatistics(session)).withMaxReadBlockSize(HiveSessionProperties.getParquetMaxReadBlockSize(session))));
    }

    public static ReaderPageSource createPageSource(Path path, long start, long length, long estimatedFileSize, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, boolean useColumnNames, HdfsEnvironment hdfsEnvironment, Configuration configuration, String user, DateTimeZone timeZone, FileFormatDataSourceStats stats, ParquetReaderOptions options) {
        ParquetReader parquetReader;
        MessageColumnIO messageColumn;
        MessageType fileSchema;
        effectivePredicate = effectivePredicate.filter((column, domain) -> column.isBaseColumn());
        HdfsParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FSDataInputStream inputStream = hdfsEnvironment.doAs(user, () -> fileSystem.open(path));
            dataSource = new HdfsParquetDataSource(new ParquetDataSourceId(path.toString()), estimatedFileSize, inputStream, stats, options);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            fileSchema = fileMetaData.getSchema();
            Optional<MessageType> message = HivePageSourceProvider.projectSufficientColumns(columns).map(projection -> projection.get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns).stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetPageSourceFactory.getColumnType(column, fileSchema, useColumnNames)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new Type[]{type})).reduce(MessageType::union);
            MessageType requestedSchema = message.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ImmutableList.Builder footerBlocks = ImmutableList.builder();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length) continue;
                footerBlocks.add((Object)block);
            }
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = options.isIgnoreStatistics() ? TupleDomain.all() : ParquetPageSourceFactory.getParquetTupleDomain(descriptorsByPath, (TupleDomain<HiveColumnHandle>)effectivePredicate, fileSchema, useColumnNames);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)timeZone);
            ImmutableList.Builder blocks = ImmutableList.builder();
            for (BlockMetaData block : footerBlocks.build()) {
                if (!PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain)) continue;
                blocks.add((Object)block);
            }
            parquetReader = new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), messageColumn, (List)blocks.build(), (ParquetDataSource)dataSource, timeZone, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), options);
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException inputStream) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
        Optional<ReaderColumns> readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
        List<HiveColumnHandle> baseColumns = readerProjections.map(projection -> projection.get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns);
        for (HiveColumnHandle column2 : baseColumns) {
            Preconditions.checkArgument((column2.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be REGULAR: %s", (Object)column2);
        }
        List parquetFields = (List)baseColumns.stream().map(column -> ParquetPageSourceFactory.getParquetType(column, fileSchema, useColumnNames)).map(Optional::ofNullable).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder trinoTypes = ImmutableList.builder();
        ImmutableList.Builder internalFields = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < baseColumns.size(); ++columnIndex) {
            HiveColumnHandle column3 = baseColumns.get(columnIndex);
            Optional parquetField = (Optional)parquetFields.get(columnIndex);
            trinoTypes.add((Object)column3.getBaseType());
            internalFields.add(parquetField.flatMap(field -> {
                String columnName = useColumnNames ? column3.getBaseColumnName() : ((Type)fileSchema.getFields().get(column3.getBaseHiveColumnIndex())).getName();
                return ParquetColumnIOConverter.constructField(column3.getBaseType(), ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)columnName));
            }));
        }
        ParquetPageSource parquetPageSource = new ParquetPageSource(parquetReader, (List<io.trino.spi.type.Type>)trinoTypes.build(), (List<Optional<Field>>)internalFields.build());
        return new ReaderPageSource(parquetPageSource, readerProjections);
    }

    public static Optional<Type> getParquetType(GroupType groupType, boolean useParquetColumnNames, HiveColumnHandle column) {
        if (useParquetColumnNames) {
            return Optional.ofNullable(ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)groupType));
        }
        if (column.getBaseHiveColumnIndex() < groupType.getFieldCount()) {
            return Optional.of(groupType.getType(column.getBaseHiveColumnIndex()));
        }
        return Optional.empty();
    }

    public static Optional<Type> getColumnType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        Optional<Type> columnType = ParquetPageSourceFactory.getParquetType((GroupType)messageType, useParquetColumnNames, column);
        if (columnType.isEmpty() || column.getHiveColumnProjectionInfo().isEmpty()) {
            return columnType;
        }
        GroupType baseType = columnType.get().asGroupType();
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        GroupType parentType = baseType;
        for (String name : column.getHiveColumnProjectionInfo().get().getDereferenceNames()) {
            Type childType = ParquetTypeUtils.getParquetTypeByName((String)name, (GroupType)parentType.asGroupType());
            if (childType == null) {
                return Optional.empty();
            }
            typeBuilder.add((Object)childType);
            parentType = childType;
        }
        ImmutableList subfieldTypes = typeBuilder.build();
        Type type = (Type)subfieldTypes.get(subfieldTypes.size() - 1);
        for (int i = subfieldTypes.size() - 2; i >= 0; --i) {
            GroupType groupType = ((Type)subfieldTypes.get(i)).asGroupType();
            type = new GroupType(type.getRepetition(), groupType.getName(), (List)ImmutableList.of((Object)type));
        }
        return Optional.of(new GroupType(baseType.getRepetition(), baseType.getName(), (List)ImmutableList.of((Object)type)));
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<HiveColumnHandle> effectivePredicate, MessageType fileSchema, boolean useColumnNames) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            RichColumnDescriptor descriptor;
            HiveColumnHandle columnHandle = (HiveColumnHandle)entry.getKey();
            if (columnHandle.getHiveType().getCategory() != ObjectInspector.Category.PRIMITIVE || columnHandle.getColumnType() != HiveColumnHandle.ColumnType.REGULAR) continue;
            if (useColumnNames) {
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()));
            } else {
                Type parquetField = ParquetPageSourceFactory.getParquetType(columnHandle, fileSchema, false);
                if (parquetField == null || !parquetField.isPrimitive()) continue;
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)parquetField.getName()));
            }
            if (descriptor == null) continue;
            predicate.put((Object)descriptor, (Object)((Domain)entry.getValue()));
        }
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    private static Type getParquetType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        if (useParquetColumnNames) {
            return ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)messageType);
        }
        if (column.getBaseHiveColumnIndex() < messageType.getFieldCount()) {
            return messageType.getType(column.getBaseHiveColumnIndex());
        }
        return null;
    }
}

