/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.TableType;

final class Procedures {
    private Procedures() {
    }

    public static void checkIsPartitionedTable(Table table) {
        if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is a view: " + table.getSchemaTableName());
        }
        if (table.getTableType().equals(TableType.MATERIALIZED_VIEW.name())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is a materialized view: " + table.getSchemaTableName());
        }
        if (table.getPartitionColumns().isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Table is not partitioned: " + table.getSchemaTableName());
        }
    }

    public static void checkPartitionColumns(Table table, List<String> expectedPartitions) {
        List actualPartitionColumnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        if (!Objects.equals(expectedPartitions, actualPartitionColumnNames)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Provided partition column names do not match actual partition column names: " + actualPartitionColumnNames);
        }
    }
}

