/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.ConfigurationInitializer;
import io.trino.plugin.hive.DynamicConfigurationProvider;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.rubix.RubixEnabledConfig;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.HiveS3TypeConfig;
import io.trino.plugin.hive.s3.S3FileSystemType;
import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import io.trino.plugin.hive.s3.S3SecurityMappingConfigurationProvider;
import io.trino.plugin.hive.s3.TrinoS3ConfigurationInitializer;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.plugin.hive.s3.TrinoS3FileSystemStats;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.weakref.jmx.guice.ExportBinder;

public class HiveS3Module
extends AbstractConfigurationAwareModule {
    public static final String EMR_FS_CLASS_NAME = "com.amazon.ws.emr.hadoop.fs.EmrFileSystem";

    protected void setup(Binder binder) {
        S3FileSystemType type = ((HiveS3TypeConfig)this.buildConfigObject(HiveS3TypeConfig.class)).getS3FileSystemType();
        switch (type) {
            case TRINO: {
                this.bindSecurityMapping(binder);
                Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(TrinoS3ConfigurationInitializer.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder((Binder)binder).bindConfig(HiveS3Config.class);
                binder.bind(TrinoS3FileSystemStats.class).toInstance((Object)TrinoS3FileSystem.getFileSystemStats());
                ExportBinder.newExporter((Binder)binder).export(TrinoS3FileSystemStats.class).as(generator -> generator.generatedNameOf(TrinoS3FileSystem.class));
                break;
            }
            case EMRFS: {
                HiveS3Module.validateEmrFsClass();
                Multibinder.newSetBinder((Binder)binder, ConfigurationInitializer.class).addBinding().to(EmrFsS3ConfigurationInitializer.class).in(Scopes.SINGLETON);
                break;
            }
            case HADOOP_DEFAULT: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown file system type: " + type);
            }
        }
    }

    private void bindSecurityMapping(Binder binder) {
        if (((S3SecurityMappingConfig)this.buildConfigObject(S3SecurityMappingConfig.class)).getConfigFile().isPresent()) {
            Preconditions.checkArgument((!((HiveConfig)this.buildConfigObject(HiveConfig.class)).isS3SelectPushdownEnabled() ? 1 : 0) != 0, (Object)"S3 security mapping is not compatible with S3 Select pushdown");
            Preconditions.checkArgument((!((RubixEnabledConfig)this.buildConfigObject(RubixEnabledConfig.class)).isCacheEnabled() ? 1 : 0) != 0, (Object)"S3 security mapping is not compatible with Hive caching");
            Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class).addBinding().to(S3SecurityMappingConfigurationProvider.class).in(Scopes.SINGLETON);
        }
    }

    private static void validateEmrFsClass() {
        try {
            Class.forName(EMR_FS_CLASS_NAME, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("EMR File System class not found: com.amazon.ws.emr.hadoop.fs.EmrFileSystem", e);
        }
    }

    public static class EmrFsS3ConfigurationInitializer
    implements ConfigurationInitializer {
        @Override
        public void initializeConfiguration(Configuration config) {
            config.set("fs.s3.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3a.impl", HiveS3Module.EMR_FS_CLASS_NAME);
            config.set("fs.s3n.impl", HiveS3Module.EMR_FS_CLASS_NAME);
        }
    }
}

