/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.amazonaws.services.s3.model.CannedAccessControlList;
import java.util.Objects;

public enum TrinoS3AclType {
    AUTHENTICATED_READ(CannedAccessControlList.AuthenticatedRead),
    AWS_EXEC_READ(CannedAccessControlList.AwsExecRead),
    BUCKET_OWNER_FULL_CONTROL(CannedAccessControlList.BucketOwnerFullControl),
    BUCKET_OWNER_READ(CannedAccessControlList.BucketOwnerRead),
    LOG_DELIVERY_WRITE(CannedAccessControlList.LogDeliveryWrite),
    PRIVATE(CannedAccessControlList.Private),
    PUBLIC_READ(CannedAccessControlList.PublicRead),
    PUBLIC_READ_WRITE(CannedAccessControlList.PublicReadWrite);

    private final CannedAccessControlList cannedACL;

    private TrinoS3AclType(CannedAccessControlList cannedACL) {
        this.cannedACL = Objects.requireNonNull(cannedACL, "cannedACL is null");
    }

    CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }
}

