/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigurationModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.security.AccessControlMetadataFactory;
import io.trino.plugin.hive.security.AllowAllSecurityModule;
import io.trino.plugin.hive.security.LegacySecurityModule;
import io.trino.plugin.hive.security.SecurityConfig;
import io.trino.plugin.hive.security.SqlStandardSecurityModule;
import java.util.Objects;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;

    public HiveSecurityModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    protected void setup(Binder binder) {
        this.bindSecurityModule("legacy", (Module)ConfigurationModule.installModules((Module[])new Module[]{new LegacySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule("file", (Module)ConfigurationModule.installModules((Module[])new Module[]{new FileBasedAccessControlModule(this.catalogName), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule("read-only", (Module)ConfigurationModule.installModules((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule("sql-standard", new SqlStandardSecurityModule());
        this.bindSecurityModule("allow-all", new AllowAllSecurityModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            binder.bind(AccessControlMetadataFactory.class).toInstance(metastore -> new AccessControlMetadata(){});
        }
    }
}

