/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.testing;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.testing.TestingHiveConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Objects;

public class TestingHivePlugin
implements Plugin {
    private final HiveMetastore metastore;
    private final Module module;

    public TestingHivePlugin(HiveMetastore metastore) {
        this(metastore, Modules.EMPTY_MODULE);
    }

    public TestingHivePlugin(HiveMetastore metastore, Module module) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new TestingHiveConnectorFactory(this.metastore, this.module));
    }
}

