/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.collect.ImmutableList;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionResolver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.util.Util;

public class DaliOperatorTable
implements SqlOperatorTable {
    private HiveFunctionResolver funcResolver;

    public DaliOperatorTable(HiveFunctionRegistry registry, ConcurrentHashMap<String, HiveFunction> dynamicRegistry) {
        this.funcResolver = new HiveFunctionResolver(registry, dynamicRegistry);
    }

    public void lookupOperatorOverloads(SqlIdentifier sqlIdentifier, SqlFunctionCategory sqlFunctionCategory, SqlSyntax sqlSyntax, List<SqlOperator> list, SqlNameMatcher sqlNameMatcher) {
        String functionName = (String)Util.last((List)sqlIdentifier.names);
        Collection<HiveFunction> functions = this.funcResolver.resolve(functionName, true);
        functions.stream().map(HiveFunction::getSqlOperator).collect(Collectors.toCollection(() -> list));
    }

    public List<SqlOperator> getOperatorList() {
        return ImmutableList.of();
    }
}

