/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.collect.ImmutableList;
import com.linkedin.coral.hive.hive2rel.RelContextProvider;
import com.linkedin.coral.hive.hive2rel.functions.GenericProjectFunction;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;

class FuzzyUnionSqlRewriter
extends SqlShuttle {
    private final String tableName;
    private final RelDataType tableDataType;
    private final RelContextProvider relContextProvider;
    private final List<String> columnNames;

    public FuzzyUnionSqlRewriter(@Nonnull Table table, @Nonnull String tableName, @Nonnull RelContextProvider relContextProvider) {
        this.relContextProvider = relContextProvider;
        this.tableName = tableName;
        this.tableDataType = table.getRowType(relContextProvider.getHiveSqlValidator().getTypeFactory());
        this.columnNames = this.tableDataType.getFieldNames();
    }

    public SqlNode visit(SqlCall call) {
        if (call.getOperator().getKind() == SqlKind.UNION) {
            call = this.addFuzzyUnionToUnionCall(call);
        }
        SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler((SqlShuttle)this, call, false);
        call.getOperator().acceptCall((SqlVisitor)this, call, false, (SqlBasicVisitor.ArgHandler)argHandler);
        return (SqlNode)argHandler.result();
    }

    private SqlNode createGenericProject(String columnName) {
        SqlNode[] genericProjectOperands = new SqlNode[]{new SqlIdentifier((List)ImmutableList.of((Object)this.tableName, (Object)columnName), SqlParserPos.ZERO), SqlLiteral.createCharString((String)columnName, (SqlParserPos)SqlParserPos.ZERO)};
        RelDataTypeField columnField = this.tableDataType.getField(columnName, false, true);
        SqlBasicCall genericProjectCall = new SqlBasicCall((SqlOperator)new GenericProjectFunction(columnField.getType()), genericProjectOperands, SqlParserPos.ZERO);
        SqlNode[] castAsColumnOperands = new SqlNode[]{genericProjectCall, new SqlIdentifier(columnName, SqlParserPos.ZERO)};
        SqlBasicCall castAsCall = new SqlBasicCall((SqlOperator)new SqlAsOperator(), castAsColumnOperands, SqlParserPos.ZERO);
        return castAsCall;
    }

    private SqlNodeList createProjectedFieldsNodeList(RelDataType fromNodeDataType) {
        SqlNodeList projectedFields = new SqlNodeList(SqlParserPos.ZERO);
        for (RelDataTypeField field : this.tableDataType.getFieldList()) {
            RelDataTypeField schemaDataTypeField = this.tableDataType.getField(field.getName(), false, false);
            RelDataTypeField inputDataTypeField = fromNodeDataType.getField(field.getName(), false, false);
            Object projectedField = field.getType().getFullTypeString().contains("RecordType") && !schemaDataTypeField.equals(inputDataTypeField) ? this.createGenericProject(field.getName()) : new SqlIdentifier((List)ImmutableList.of((Object)this.tableName, (Object)field.getName()), SqlParserPos.ZERO);
            projectedFields.add(projectedField);
        }
        return projectedFields;
    }

    private SqlNode addFuzzyUnionToUnionBranch(SqlNode unionBranch) {
        RelDataType fromNodeDataType = this.relContextProvider.getHiveSqlValidator().getValidatedNodeTypeIfKnown(unionBranch);
        if (fromNodeDataType == null) {
            this.relContextProvider.getHiveSqlValidator().validate(unionBranch);
            fromNodeDataType = this.relContextProvider.getHiveSqlValidator().getValidatedNodeType(unionBranch);
        }
        if (this.tableDataType.equals(fromNodeDataType) || !fromNodeDataType.isStruct() || fromNodeDataType.getFieldCount() < this.tableDataType.getFieldCount()) {
            return unionBranch;
        }
        Set fromNodeFieldNames = fromNodeDataType.getFieldList().stream().map(f -> f.getName()).collect(Collectors.toSet());
        if (!fromNodeFieldNames.containsAll(this.columnNames)) {
            return unionBranch;
        }
        SqlNodeList projectedFields = this.createProjectedFieldsNodeList(fromNodeDataType);
        SqlNode[] castTableOperands = new SqlNode[]{unionBranch, new SqlIdentifier(this.tableName, SqlParserPos.ZERO)};
        SqlBasicCall castTableCall = new SqlBasicCall((SqlOperator)new SqlAsOperator(), castTableOperands, SqlParserPos.ZERO);
        SqlSelect selectOperator = new SqlSelect(SqlParserPos.ZERO, new SqlNodeList(SqlParserPos.ZERO), projectedFields, (SqlNode)castTableCall, null, null, null, null, null, null, null);
        return selectOperator;
    }

    private SqlCall addFuzzyUnionToUnionCall(SqlCall unionCall) {
        for (int i = 0; i < unionCall.operandCount(); ++i) {
            SqlNode operand = unionCall.operand(i);
            if (this.isUnionOperator(operand)) continue;
            unionCall.setOperand(i, this.addFuzzyUnionToUnionBranch(operand));
        }
        return unionCall;
    }

    private boolean isUnionOperator(SqlNode node) {
        return node instanceof SqlCall && ((SqlCall)node).getOperator().getKind() == SqlKind.UNION;
    }
}

