/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class HiveRelConverter
extends RelShuttleImpl {
    public RelNode convert(RelNode relNode) {
        return relNode.accept((RelShuttle)this);
    }

    public RelNode visit(LogicalAggregate aggregate) {
        return super.visit(aggregate).accept((RexShuttle)this.getRexTransformer((RelNode)aggregate));
    }

    public RelNode visit(LogicalMatch match) {
        return super.visit(match).accept((RexShuttle)this.getRexTransformer((RelNode)match));
    }

    public RelNode visit(TableScan scan) {
        return super.visit(scan).accept((RexShuttle)this.getRexTransformer((RelNode)scan));
    }

    public RelNode visit(TableFunctionScan scan) {
        return super.visit(scan).accept((RexShuttle)this.getRexTransformer((RelNode)scan));
    }

    public RelNode visit(LogicalValues values) {
        return super.visit(values).accept((RexShuttle)this.getRexTransformer((RelNode)values));
    }

    public RelNode visit(LogicalFilter filter) {
        return super.visit(filter).accept((RexShuttle)this.getRexTransformer((RelNode)filter));
    }

    public RelNode visit(LogicalJoin join) {
        return super.visit(join).accept((RexShuttle)this.getRexTransformer((RelNode)join));
    }

    public RelNode visit(LogicalCorrelate correlate) {
        return super.visit(correlate).accept((RexShuttle)this.getRexTransformer((RelNode)correlate));
    }

    public RelNode visit(LogicalUnion union) {
        return super.visit(union).accept((RexShuttle)this.getRexTransformer((RelNode)union));
    }

    public RelNode visit(LogicalIntersect intersect) {
        return super.visit(intersect).accept((RexShuttle)this.getRexTransformer((RelNode)intersect));
    }

    public RelNode visit(LogicalMinus minus) {
        return super.visit(minus).accept((RexShuttle)this.getRexTransformer((RelNode)minus));
    }

    public RelNode visit(LogicalSort sort) {
        return super.visit(sort).accept((RexShuttle)this.getRexTransformer((RelNode)sort));
    }

    public RelNode visit(LogicalExchange exchange) {
        return super.visit(exchange).accept((RexShuttle)this.getRexTransformer((RelNode)exchange));
    }

    public RelNode visit(RelNode other) {
        return super.visit(other).accept((RexShuttle)this.getRexTransformer(other));
    }

    private HiveRexConverter getRexTransformer(RelNode rel) {
        return new HiveRexConverter(rel.getCluster().getRexBuilder());
    }

    public RelNode visit(LogicalProject project) {
        Project oldProject = (Project)super.visit(project);
        HiveRexConverter rexTransformer = new HiveRexConverter(project.getCluster().getRexBuilder());
        List newProjects = project.getProjects().stream().map(arg_0 -> ((HiveRexConverter)rexTransformer).apply(arg_0)).collect(Collectors.toList());
        return LogicalProject.create((RelNode)oldProject.getInput(), newProjects, (List)oldProject.getRowType().getFieldNames());
    }

    static class HiveRexConverter
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        HiveRexConverter(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall inputCall) {
            RexNode call = super.visitCall(inputCall);
            if (call instanceof RexCall) {
                call = this.convertToOneBasedArrayIndex((RexCall)call);
            }
            return call;
        }

        private RexNode convertToOneBasedArrayIndex(RexCall call) {
            if (call.getOperator().equals((Object)SqlStdOperatorTable.ITEM)) {
                RexNode columnRef = (RexNode)call.getOperands().get(0);
                RexNode itemRef = (RexNode)call.getOperands().get(1);
                if (columnRef.getType() instanceof ArraySqlType && itemRef.isA(SqlKind.LITERAL) && itemRef.getType().getSqlTypeName().equals((Object)SqlTypeName.INTEGER)) {
                    Integer val = (Integer)((RexLiteral)itemRef).getValueAs(Integer.class);
                    RexLiteral newItemRef = this.rexBuilder.makeExactLiteral(new BigDecimal(val + 1), itemRef.getType());
                    return this.rexBuilder.makeCall(call.op, new RexNode[]{columnRef, newItemRef});
                }
            }
            return call;
        }
    }
}

