/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.linkedin.coral.hive.hive2rel.rel.HiveUncollect;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;

class HiveSqlToRelConverter
extends SqlToRelConverter {
    HiveSqlToRelConverter(RelOptTable.ViewExpander viewExpander, SqlValidator validator, Prepare.CatalogReader catalogReader, RelOptCluster cluster, SqlRexConvertletTable convertletTable, SqlToRelConverter.Config config) {
        super(viewExpander, validator, catalogReader, cluster, convertletTable, config);
    }

    public RelRoot convertQuery(SqlNode query, boolean needsValidation, boolean top) {
        if (needsValidation) {
            query = this.validator.validate(query);
        }
        RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)this.cluster.getMetadataProvider()));
        RelNode result = this.convertQueryRecursive((SqlNode)query, (boolean)top, null).rel;
        RelCollation collation = RelCollations.EMPTY;
        if (SQL2REL_LOGGER.isDebugEnabled()) {
            SQL2REL_LOGGER.debug(RelOptUtil.dumpPlan((String)"Plan after converting SqlNode to RelNode", (RelNode)result, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        RelDataType validatedRowType = this.validator.getValidatedNodeType(query);
        return RelRoot.of((RelNode)result, (RelDataType)validatedRowType, (SqlKind)query.getKind()).withCollation(collation);
    }

    protected void convertFrom(SqlToRelConverter.Blackboard bb, SqlNode from) {
        if (from == null) {
            super.convertFrom(bb, from);
            return;
        }
        switch (from.getKind()) {
            case UNNEST: {
                this.convertUnnestFrom(bb, from);
                break;
            }
            default: {
                super.convertFrom(bb, from);
            }
        }
    }

    private void convertUnnestFrom(SqlToRelConverter.Blackboard bb, SqlNode from) {
        SqlCall call = (SqlCall)from;
        List nodes = call.getOperandList();
        SqlUnnestOperator operator = (SqlUnnestOperator)call.getOperator();
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Ord node : Ord.zip((List)nodes)) {
            exprs.add(bb.convertExpression((SqlNode)node.e));
            fieldNames.add(this.validator.deriveAlias((SqlNode)node.e, node.i));
        }
        RelNode input = RelOptUtil.createProject((RelNode)(null != bb.root ? bb.root : LogicalValues.createOneRow((RelOptCluster)this.cluster)), exprs, fieldNames, (boolean)true);
        HiveUncollect uncollect = new HiveUncollect(this.cluster, this.cluster.traitSetOf((RelTrait)Convention.NONE), input, operator.withOrdinality);
        bb.setRoot((RelNode)uncollect, true);
    }
}

