/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.annotations.VisibleForTesting;
import com.linkedin.coral.hive.hive2rel.FuzzyUnionSqlRewriter;
import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.HiveRelConverter;
import com.linkedin.coral.hive.hive2rel.RelContextProvider;
import com.linkedin.coral.hive.hive2rel.parsetree.ParseTreeBuilder;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlVisitor;

public class HiveToRelConverter {
    private final RelContextProvider relContextProvider;

    public static HiveToRelConverter create(HiveMetastoreClient mscClient) {
        Preconditions.checkNotNull((Object)mscClient);
        RelContextProvider relContextProvider = new RelContextProvider(mscClient);
        return new HiveToRelConverter(relContextProvider);
    }

    public static HiveToRelConverter create(Map<String, Map<String, List<String>>> localMetaStore) {
        Preconditions.checkNotNull(localMetaStore);
        RelContextProvider relContextProvider = new RelContextProvider(localMetaStore);
        return new HiveToRelConverter(relContextProvider);
    }

    private HiveToRelConverter(RelContextProvider relContextProvider) {
        Preconditions.checkNotNull((Object)relContextProvider);
        this.relContextProvider = relContextProvider;
    }

    public RelNode convertSql(String sql) {
        SqlNode sqlNode = this.getTreeBuilder().processSql(sql);
        return this.toRel(sqlNode);
    }

    private RelNode standardizeRel(RelNode relNode) {
        return new HiveRelConverter().convert(relNode);
    }

    public RelNode convertView(String hiveDbName, String hiveViewName) {
        SqlNode sqlNode = this.getTreeBuilder().processView(hiveDbName, hiveViewName);
        Table view = this.relContextProvider.getHiveSchema().getSubSchema(hiveDbName).getTable(hiveViewName);
        if (view != null) {
            sqlNode.accept((SqlVisitor)new FuzzyUnionSqlRewriter(view, hiveViewName, this.relContextProvider));
        }
        return this.toRel(sqlNode);
    }

    @VisibleForTesting
    ParseTreeBuilder getTreeBuilder() {
        if (this.relContextProvider.getHiveSchema() == null) {
            return new ParseTreeBuilder(null, this.relContextProvider.getParseTreeBuilderConfig(), this.relContextProvider.getHiveFunctionRegistry(), this.relContextProvider.getDynamicHiveFunctionRegistry());
        }
        return new ParseTreeBuilder(this.relContextProvider.getHiveMetastoreClient(), this.relContextProvider.getParseTreeBuilderConfig(), this.relContextProvider.getHiveFunctionRegistry(), this.relContextProvider.getDynamicHiveFunctionRegistry());
    }

    @VisibleForTesting
    RelNode toRel(SqlNode sqlNode) {
        RelRoot root = this.relContextProvider.getSqlToRelConverter().convertQuery(sqlNode, true, true);
        return this.standardizeRel(root.rel);
    }
}

