/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.RelContextProvider;
import com.linkedin.coral.hive.hive2rel.parsetree.ParseTreeBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveViewExpander
implements RelOptTable.ViewExpander {
    private final RelContextProvider relContextProvider;

    public HiveViewExpander(@Nonnull RelContextProvider relContextProvider) {
        Preconditions.checkNotNull((Object)relContextProvider);
        this.relContextProvider = relContextProvider;
    }

    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        Preconditions.checkNotNull(viewPath);
        Preconditions.checkState((!viewPath.isEmpty() ? 1 : 0) != 0);
        HiveMetastoreClient msc = this.relContextProvider.getHiveMetastoreClient();
        String dbName = (String)Util.last(schemaPath);
        String tableName = viewPath.get(0);
        Table table = msc.getTable(dbName, tableName);
        if (table == null) {
            throw new RuntimeException(String.format("Table %s.%s not found", dbName, tableName));
        }
        ParseTreeBuilder treeBuilder = new ParseTreeBuilder(msc, this.relContextProvider.getParseTreeBuilderConfig(), this.relContextProvider.getHiveFunctionRegistry(), this.relContextProvider.getDynamicHiveFunctionRegistry());
        SqlNode viewNode = treeBuilder.processViewOrTable(table);
        return this.relContextProvider.getSqlToRelConverter().convertQuery(viewNode, true, true);
    }
}

