/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import groovy.grape.Grape;
import groovy.lang.GroovyClassLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactsResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactsResolver.class);
    private static final String IVY_SETTINGS_LOCATION = "IVY_SETTINGS_LOCATION";
    private static final String IVY_SETTINGS_FILE_NAME = "ivy.settings.xml";

    public List<URI> downloadDependencies(URI artifactUri) {
        HashMap artifactMap = Maps.newHashMap();
        String authority = artifactUri.getAuthority();
        Preconditions.checkArgument((authority != null ? 1 : 0) != 0, (Object)"Invalid artifactUri: Expected artifactUri's authority as 'org:module:version', found null");
        String[] authorityTokens = authority.split(":");
        Preconditions.checkArgument((authorityTokens.length == 3 ? 1 : 0) != 0, (Object)("Invalid artifactUri: Expected 'org:module:version', found " + authority));
        artifactMap.put("org", authorityTokens[0]);
        artifactMap.put("module", authorityTokens[1]);
        artifactMap.put("version", authorityTokens[2]);
        Map<String, Object> queryMap = ArtifactsResolver.parseQueryString(artifactUri.getQuery());
        artifactMap.putAll(queryMap);
        return ArtifactsResolver.grab(artifactMap);
    }

    private static Map<String, Object> parseQueryString(String queryString) {
        String[] tokens;
        if (Strings.isNullOrEmpty((String)queryString)) {
            return ImmutableMap.of();
        }
        HashSet excludes = Sets.newHashSet();
        HashMap queryMap = Maps.newHashMap();
        for (String token : tokens = queryString.split("&")) {
            String[] kvPair = token.split("=");
            Preconditions.checkArgument((kvPair.length == 2 ? 1 : 0) != 0, (Object)("Invalid query string: " + queryString + ". Token: " + token + " not a key-value pair separated by '='"));
            if (kvPair[0].equals("exclude")) {
                excludes.addAll(ArtifactsResolver.computeExcludes(kvPair[1]));
                continue;
            }
            if (kvPair[0].equals("transitive")) {
                queryMap.put(kvPair[0], Boolean.parseBoolean(kvPair[1]));
                continue;
            }
            queryMap.put(kvPair[0], kvPair[1]);
        }
        if (!excludes.isEmpty()) {
            queryMap.put("exclude", excludes);
        }
        return queryMap;
    }

    private static Set<Map<String, String>> computeExcludes(String excludeStr) throws RuntimeException {
        String[] excludes = excludeStr.split(",");
        HashSet excludeSet = Sets.newHashSet();
        for (String exclude : excludes) {
            HashMap artifactMap = Maps.newHashMap();
            if (exclude.indexOf(58) != -1) {
                String[] args = exclude.split(":");
                Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)("Invalid exclude string: expected 'org[:module]?', found: " + exclude));
                artifactMap.put("group", args[0]);
                artifactMap.put("module", args[1]);
            } else {
                artifactMap.put("group", exclude);
                artifactMap.put("module", "*");
            }
            excludeSet.add(artifactMap);
        }
        return excludeSet;
    }

    private static List<URI> grab(Map<String, Object> artifact) {
        HashMap args = Maps.newHashMap();
        if (artifact.containsKey("exclude")) {
            args.put("excludes", artifact.get("exclude"));
        }
        if (!artifact.containsKey("transitive")) {
            artifact.put("transitive", true);
        }
        args.put("classLoader", new GroovyClassLoader());
        try {
            LOG.info("Resolving artifact: " + artifact);
            Object[] uris = Grape.resolve((Map)args, (Map[])new Map[]{artifact});
            LOG.info("Finish resolving artifact: " + Arrays.toString(uris));
            return Lists.newArrayList((Object[])uris);
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("configuration not found")) {
                throw new RuntimeException("configuration not found", e);
            }
            throw new RuntimeException("cannot resolve artifact", e);
        }
    }

    private static File getIvySettingsFile() {
        if (System.getenv().containsKey(IVY_SETTINGS_LOCATION)) {
            String s = System.getenv().get(IVY_SETTINGS_LOCATION);
            File settingsFile = new File(s);
            if (!settingsFile.exists()) {
                throw new RuntimeException("Ivy settings file: " + settingsFile + " specified under " + IVY_SETTINGS_LOCATION + " does not exist");
            }
            LOG.info("Reading Ivy settings from: " + settingsFile);
            return settingsFile;
        }
        return ArtifactsResolver.setupIvyFileFromClassPath();
    }

    private static File setupIvyFileFromClassPath() {
        URL settingsUrl = Thread.currentThread().getContextClassLoader().getResource(IVY_SETTINGS_FILE_NAME);
        if (settingsUrl == null) {
            throw new RuntimeException("Failed to find ivy.settings.xml from class path");
        }
        LOG.info("Ivy settings url: " + settingsUrl);
        File ivySettingsFile = new File(settingsUrl.getFile());
        if (ivySettingsFile.exists()) {
            return ivySettingsFile;
        }
        try {
            ivySettingsFile = File.createTempFile("ivy.settings", ".xml");
            ivySettingsFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary Ivy settings file.", e);
        }
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(ivySettingsFile));){
            Resources.copy((URL)settingsUrl, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to setup ivy settings file: " + ivySettingsFile, e);
        }
        LOG.info("Created ivy settings file: " + ivySettingsFile + " for current session");
        return ivySettingsFile;
    }

    private static void setupGrape(File ivySettingsFile) {
        File grapeRootDir;
        System.setProperty("grape.config", ivySettingsFile.getAbsolutePath());
        LOG.info("Resolving grape.root dir.");
        String grapeRoot = System.getProperty("grape.root");
        if (!Strings.isNullOrEmpty((String)grapeRoot)) {
            grapeRootDir = new File(grapeRoot);
            if (grapeRootDir.exists() || grapeRootDir.mkdirs()) {
                LOG.info("Using Grape root dir: " + grapeRoot);
                return;
            }
            LOG.warn("Grape.root system property is not valid: " + grapeRoot);
        } else {
            LOG.info("Grape.root system property is not set.");
        }
        grapeRoot = System.getProperty("user.home") + "/.groovy/grapes";
        grapeRootDir = new File(grapeRoot);
        if (grapeRootDir.exists() || grapeRootDir.mkdirs()) {
            System.setProperty("grape.root", grapeRoot);
            LOG.info("Using Grape root dir: " + grapeRoot);
            return;
        }
        LOG.warn("Home dir is not valid as grape.root.");
        File tmpDir = new File("" + System.currentTimeMillis());
        if (!tmpDir.mkdirs()) {
            throw new RuntimeException("Unable to make grape root dir: " + tmpDir.getAbsolutePath());
        }
        System.setProperty("grape.root", tmpDir.getAbsolutePath());
        LOG.info("Using Grape root dir: " + tmpDir.getAbsolutePath());
    }

    static {
        File ivySettingsFile = ArtifactsResolver.getIvySettingsFile();
        ArtifactsResolver.setupGrape(ivySettingsFile);
    }
}

