/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.hive.hive2rel.functions.HiveInOperator;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Util;

public class HiveFunction {
    private final String hiveName;
    private final SqlOperator sqlOperator;
    public static final HiveFunction CAST = new HiveFunction("cast", (SqlOperator)SqlStdOperatorTable.CAST){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            Preconditions.checkArgument((operands.size() == 1 ? 1 : 0) != 0);
            return super.createCall(null, (List<SqlNode>)ImmutableList.of((Object)operands.get(0), (Object)function), null);
        }
    };
    public static final HiveFunction CASE = new HiveFunction("case", (SqlOperator)SqlStdOperatorTable.CASE){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> thenNodes = new ArrayList<SqlNode>();
            for (int i = 1; i < operands.size() - 1; i += 2) {
                whenNodes.add(operands.get(i));
                thenNodes.add(operands.get(i + 1));
            }
            SqlLiteral elseNode = operands.size() % 2 == 1 ? SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO) : (SqlNode)Util.last(operands);
            return this.getSqlOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{operands.get(0), new SqlNodeList(whenNodes, SqlParserPos.ZERO), new SqlNodeList(thenNodes, SqlParserPos.ZERO), elseNode});
        }
    };
    public static final HiveFunction WHEN = new HiveFunction("when", (SqlOperator)SqlStdOperatorTable.CASE){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
            ArrayList<SqlNode> thenNodes = new ArrayList<SqlNode>();
            for (int i = 0; i < operands.size() - 1; i += 2) {
                whenNodes.add(operands.get(i));
                thenNodes.add(operands.get(i + 1));
            }
            SqlLiteral elseNode = operands.size() % 2 == 0 ? SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO) : (SqlNode)Util.last(operands);
            return this.getSqlOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{null, new SqlNodeList(whenNodes, SqlParserPos.ZERO), new SqlNodeList(thenNodes, SqlParserPos.ZERO), elseNode});
        }
    };
    public static final HiveFunction BETWEEN = new HiveFunction("between", (SqlOperator)SqlStdOperatorTable.BETWEEN){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkNotNull(operands);
            Preconditions.checkArgument((operands.size() >= 3 && operands.get(0) instanceof SqlLiteral ? 1 : 0) != 0);
            SqlLiteral opType = (SqlLiteral)operands.get(0);
            List<SqlNode> callParams = operands.subList(1, operands.size());
            if (opType.booleanValue()) {
                return SqlStdOperatorTable.NOT_BETWEEN.createCall(SqlParserPos.ZERO, callParams);
            }
            return SqlStdOperatorTable.BETWEEN.createCall(SqlParserPos.ZERO, callParams);
        }
    };
    public static final HiveFunction IN = new HiveFunction("in", (SqlOperator)HiveInOperator.IN){

        @Override
        public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
            Preconditions.checkState((operands.size() >= 2 ? 1 : 0) != 0);
            SqlNode lhs = operands.get(0);
            SqlNode firstRhs = operands.get(1);
            if (firstRhs instanceof SqlSelect) {
                return SqlStdOperatorTable.IN.createCall(SqlParserPos.ZERO, operands);
            }
            List<SqlNode> rhsList = operands.subList(1, operands.size());
            SqlNodeList rhs = new SqlNodeList(rhsList, SqlParserPos.ZERO);
            return this.getSqlOperator().createCall(SqlParserPos.ZERO, new SqlNode[]{lhs, rhs});
        }
    };

    public HiveFunction(String functionName, SqlOperator sqlOperator) {
        this.hiveName = functionName;
        this.sqlOperator = sqlOperator;
    }

    public String getHiveFunctionName() {
        return this.hiveName;
    }

    public SqlOperator getSqlOperator() {
        return this.sqlOperator;
    }

    public SqlCall createCall(SqlNode function, List<SqlNode> operands, SqlLiteral qualifier) {
        return this.sqlOperator.createCall(qualifier, SqlParserPos.ZERO, operands.toArray(new SqlNode[operands.size()]));
    }
}

