/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.linkedin.coral.hive.hive2rel.TypeConverter;
import com.linkedin.coral.hive.hive2rel.functions.ArtifactsResolver;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveGenericUDFReturnTypeInference
implements SqlReturnTypeInference {
    private final String _udfClassName;
    private final List<String> _udfDependencies;
    private final ArtifactsResolver _artifactsResolver;

    public HiveGenericUDFReturnTypeInference(String udfClassName, List<String> udfDependencies) {
        this._udfClassName = udfClassName;
        this._udfDependencies = udfDependencies;
        this._artifactsResolver = new ArtifactsResolver();
    }

    public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
        int operandCount = sqlOperatorBinding.getOperandCount();
        ObjectInspector[] inputObjectInspectors = new ObjectInspector[operandCount];
        for (int i = 0; i < sqlOperatorBinding.getOperandCount(); ++i) {
            inputObjectInspectors[i] = this.getHiveObjectInspector(sqlOperatorBinding.getOperandType(i));
        }
        Object[] inputObjectInspectorsParam = new Object[]{inputObjectInspectors};
        try {
            Class udfClass = this.getUDFClass();
            return this.getCalciteRelDataType((ObjectInspector)udfClass.getMethod("initialize", ObjectInspector[].class).invoke(udfClass.newInstance(), inputObjectInspectorsParam), sqlOperatorBinding.getTypeFactory());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find org.apache.hadoop.hive.ql.udf.generic.GenericUDF.initialize() on: " + this._udfClassName, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate a new instance of " + this._udfClassName, e);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Unable to call org.apache.hadoop.hive.ql.udf.generic.GenericUDF.initialize() on: " + this._udfClassName, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class  " + this._udfClassName, e);
        }
    }

    private ObjectInspector getHiveObjectInspector(RelDataType relDataType) {
        TypeInfo typeInfo = TypeConverter.convert(relDataType);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
        return objectInspector;
    }

    private RelDataType getCalciteRelDataType(ObjectInspector hiveObjectInspector, RelDataTypeFactory relDataTypeFactory) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)hiveObjectInspector);
        RelDataType relDataType = TypeConverter.convert(typeInfo, relDataTypeFactory);
        return relDataType;
    }

    private final Class getUDFClass() throws ClassNotFoundException {
        try {
            URL[] urls = (URL[])this._udfDependencies.stream().flatMap(udfDependency -> this._artifactsResolver.downloadDependencies(HiveGenericUDFReturnTypeInference.uri(udfDependency)).stream()).map(uri -> HiveGenericUDFReturnTypeInference.url(uri)).toArray(URL[]::new);
            URLClassLoader classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            return Class.forName(this._udfClassName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Could not load class " + this._udfClassName, e);
        }
    }

    private static URI uri(String dependency) {
        String ivyDependency = dependency.startsWith("ivy://") ? dependency : "ivy://" + dependency;
        try {
            return new URI(ivyDependency);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid UDF dependency syntax in DaliView definition: " + ivyDependency, e);
        }
    }

    private static URL url(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + uri, e);
        }
    }
}

