/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public class HiveReturnTypes {
    public static final SqlReturnTypeInference ARG1_OR_ARG2 = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            Preconditions.checkState((opBinding.getOperandCount() == 3 ? 1 : 0) != 0);
            if (!opBinding.isOperandNull(1, false)) {
                return opBinding.getOperandType(1);
            }
            return opBinding.getOperandType(2);
        }
    };
    public static final SqlReturnTypeInference STRING = ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARCHAR);
    public static final SqlReturnTypeInference BINARY = ReturnTypes.explicit((SqlTypeName)SqlTypeName.BINARY);
    public static final SqlReturnTypeInference BIGINT = ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT);
    public static final SqlReturnTypeInference ARRAY_OF_STR_STR_MAP = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType strType = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            return typeFactory.createArrayType(typeFactory.createMapType(strType, strType), -1L);
        }
    };

    private HiveReturnTypes() {
    }

    public static SqlReturnTypeInference arrayOfType(final SqlTypeName typeName) {
        return new SqlReturnTypeInference(){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                return opBinding.getTypeFactory().createArrayType(opBinding.getTypeFactory().createSqlType(typeName), -1L);
            }
        };
    }

    public static SqlReturnTypeInference mapOfType(final SqlTypeName keyType, final SqlTypeName valueType) {
        return new SqlReturnTypeInference(){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                return typeFactory.createMapType(typeFactory.createSqlType(keyType), typeFactory.createSqlType(valueType));
            }
        };
    }

    public static SqlReturnTypeInference rowOf(final ImmutableList<String> fieldNames, final ImmutableList<SqlTypeName> types) {
        return new SqlReturnTypeInference(){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                List relTypes = types.stream().map(arg_0 -> ((RelDataTypeFactory)typeFactory).createSqlType(arg_0)).collect(Collectors.toList());
                return typeFactory.createStructType(relTypes, (List)fieldNames);
            }
        };
    }

    public static SqlReturnTypeInference rowOfInference(final ImmutableList<String> fieldNames, final ImmutableList<SqlReturnTypeInference> types) {
        return new SqlReturnTypeInference(){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
                List relTypes = types.stream().map(t -> t.inferReturnType(opBinding)).collect(Collectors.toList());
                return typeFactory.createStructType(relTypes, (List)fieldNames);
            }
        };
    }
}

