/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.parsetree;

import com.google.common.base.Preconditions;
import com.linkedin.coral.hive.hive2rel.parsetree.UnhandledASTTokenException;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ASTNode;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.Node;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractASTVisitor<R, C> {
    protected R visit(ASTNode node, C ctx) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 0: {
                return this.visitNil(node, ctx);
            }
            case 841: {
                return this.visitSubquery(node, ctx);
            }
            case 842: {
                return this.visitSubqueryExpr(node, ctx);
            }
            case 843: {
                return this.visitSubqueryOp(node, ctx);
            }
            case 689: {
                return this.visitFrom(node, ctx);
            }
            case 888: 
            case 889: {
                return this.visitUnion(node, ctx);
            }
            case 787: {
                return this.visitQueryNode(node, ctx);
            }
            case 875: {
                return this.visitTabRefNode(node, ctx);
            }
            case 874: {
                return this.visitTabnameNode(node, ctx);
            }
            case 26: {
                return this.visitIdentifier(node, ctx);
            }
            case 307: {
                return this.visitStringLiteral(node, ctx);
            }
            case 7: {
                return this.visitBigintLiteral(node, ctx);
            }
            case 715: {
                return this.visitInsert(node, ctx);
            }
            case 668: {
                return null;
            }
            case 804: {
                return this.visitSelectDistinct(node, ctx);
            }
            case 728: {
                return this.visitLimit(node, ctx);
            }
            case 803: {
                return this.visitSelect(node, ctx);
            }
            case 805: {
                return this.visitSelectExpr(node, ctx);
            }
            case 594: {
                return this.visitAllColRef(node, ctx);
            }
            case 703: {
                return this.visitHaving(node, ctx);
            }
            case 904: {
                return this.visitWhere(node, ctx);
            }
            case 700: {
                return this.visitGroupBy(node, ctx);
            }
            case 762: {
                return this.visitOrderBy(node, ctx);
            }
            case 876: {
                return this.visitSortColNameAsc(node, ctx);
            }
            case 877: {
                return this.visitSortColNameDesc(node, ctx);
            }
            case 691: {
                return this.visitFunction(node, ctx);
            }
            case 692: {
                return this.visitFunctionDistinct(node, ctx);
            }
            case 693: {
                return this.visitFunctionStar(node, ctx);
            }
            case 17: {
                return this.visitDotOperator(node, ctx);
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 33: 
            case 151: 
            case 171: 
            case 178: 
            case 208: 
            case 218: 
            case 288: 
            case 289: 
            case 293: 
            case 294: 
            case 295: 
            case 297: 
            case 305: 
            case 308: {
                return this.visitOperator(node, ctx);
            }
            case 291: {
                return this.visitLParen(node, ctx);
            }
            case 260: {
                return this.visitTrue(node, ctx);
            }
            case 107: {
                return this.visitFalse(node, ctx);
            }
            case 741: {
                return this.visitNullToken(node, ctx);
            }
            case 296: {
                return this.visitNumber(node, ctx);
            }
            case 871: {
                return this.visitTableTokOrCol(node, ctx);
            }
            case -1: {
                return null;
            }
            case 35: 
            case 49: 
            case 50: 
            case 102: 
            case 128: 
            case 131: 
            case 162: 
            case 245: 
            case 282: 
            case 718: 
            case 719: {
                return this.visitKeywordLiteral(node, ctx);
            }
            case 637: {
                return this.visitBoolean(node, ctx);
            }
            case 717: {
                return this.visitInt(node, ctx);
            }
            case 838: {
                return this.visitString(node, ctx);
            }
            case 636: {
                return this.visitBinary(node, ctx);
            }
            case 672: {
                return this.visitDouble(node, ctx);
            }
            case 688: {
                return this.visitFloat(node, ctx);
            }
            case 635: {
                return this.visitBigInt(node, ctx);
            }
            case 883: {
                return this.visitTinyInt(node, ctx);
            }
            case 833: {
                return this.visitSmallInt(node, ctx);
            }
            case 639: {
                return this.visitChar(node, ctx);
            }
            case 662: {
                return this.visitDecimal(node, ctx);
            }
            case 900: {
                return this.visitVarchar(node, ctx);
            }
            case 657: {
                return this.visitDate(node, ctx);
            }
            case 658: {
                return this.visitDateLiteral(node, ctx);
            }
            case 881: {
                return this.visitTimestamp(node, ctx);
            }
            case 721: {
                return this.visitJoin(node, ctx);
            }
            case 724: {
                return this.visitLeftOuterJoin(node, ctx);
            }
            case 799: {
                return this.visitRightOuterJoin(node, ctx);
            }
            case 690: {
                return this.visitFullOuterJoin(node, ctx);
            }
            case 652: {
                return this.visitCrossJoin(node, ctx);
            }
            case 725: {
                return this.visitLeftSemiJoin(node, ctx);
            }
            case 722: {
                return this.visitLateralView(node, ctx);
            }
            case 723: {
                return this.visitLateralViewOuter(node, ctx);
            }
            case 848: {
                return this.visitTabAlias(node, ctx);
            }
        }
        throw new UnhandledASTTokenException(node);
    }

    protected R visitKeywordLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected List<R> visitChildren(ASTNode node, C ctx) {
        Preconditions.checkNotNull((Object)node, ctx);
        Preconditions.checkNotNull(ctx);
        if (node.getChildren() == null) {
            return null;
        }
        return this.visitChildren(node.getChildren(), ctx);
    }

    protected List<R> visitChildren(List<Node> nodes, C ctx) {
        return nodes.stream().map(n -> this.visit((ASTNode)n, ctx)).collect(Collectors.toList());
    }

    protected R visitTabAlias(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLateralView(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLateralViewOuter(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLeftSemiJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitCrossJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFullOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitRightOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLeftOuterJoin(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFalse(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTrue(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNullToken(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLimit(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitUnion(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNumber(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitAllColRef(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitHaving(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitWhere(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSortColNameDesc(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSortColNameAsc(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitOrderBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitGroupBy(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitOperator(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDotOperator(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitLParen(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunctionStar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunctionDistinct(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFunction(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelectExpr(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelectDistinct(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSelect(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTabRefNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTabnameNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubqueryOp(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubqueryExpr(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSubquery(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFrom(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIdentifier(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitStringLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBigintLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitQueryNode(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitNil(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBoolean(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitSmallInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBigInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTinyInt(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitFloat(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDouble(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitVarchar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitChar(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitString(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitBinary(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDecimal(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDate(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitDateLiteral(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTimestamp(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitTableTokOrCol(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitInsert(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIsNull(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }

    protected R visitIsNotNull(ASTNode node, C ctx) {
        return this.visitChildren(node, ctx).get(0);
    }
}

