/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.parsetree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.Iterables;
import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.functions.FunctionFieldReferenceOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveExplodeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunctionResolver;
import com.linkedin.coral.hive.hive2rel.functions.StaticHiveFunctionRegistry;
import com.linkedin.coral.hive.hive2rel.parsetree.AbstractASTVisitor;
import com.linkedin.coral.hive.hive2rel.parsetree.UnhandledASTTokenException;
import com.linkedin.coral.hive.hive2rel.parsetree.UnsupportedASTException;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ASTNode;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ParseDriver;
import com.linkedin.coral.hive.hive2rel.parsetree.parser.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.metastore.api.Table;

public class ParseTreeBuilder
extends AbstractASTVisitor<SqlNode, ParseContext> {
    private final HiveMetastoreClient hiveMetastoreClient;
    private final Config config;
    private final HiveFunctionResolver functionResolver;
    private HiveFunctionRegistry registry;

    public ParseTreeBuilder(HiveMetastoreClient hiveMetastoreClient, Config config, HiveFunctionRegistry registry, ConcurrentHashMap<String, HiveFunction> dynamicRegistry) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((config.catalogName.isEmpty() || !config.defaultDBName.isEmpty() ? 1 : 0) != 0, (Object)"Default DB is required if catalog name is not empty");
        this.hiveMetastoreClient = hiveMetastoreClient;
        this.config = config;
        this.functionResolver = new HiveFunctionResolver(registry, dynamicRegistry);
    }

    public ParseTreeBuilder(@Nullable HiveMetastoreClient hiveMetastoreClient, Config config) {
        this.hiveMetastoreClient = hiveMetastoreClient;
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((config.catalogName.isEmpty() || !config.defaultDBName.isEmpty() ? 1 : 0) != 0, (Object)"Default DB is required if catalog name is not empty");
        this.config = config;
        this.functionResolver = new HiveFunctionResolver(new StaticHiveFunctionRegistry(), new ConcurrentHashMap<String, HiveFunction>());
    }

    public SqlNode processViewOrTable(@Nonnull Table hiveView) {
        Preconditions.checkNotNull((Object)hiveView);
        String stringViewExpandedText = null;
        stringViewExpandedText = hiveView.getTableType().equals("VIRTUAL_VIEW") ? hiveView.getViewExpandedText() : "SELECT * FROM " + hiveView.getDbName() + "." + hiveView.getTableName();
        return this.process(stringViewExpandedText, hiveView);
    }

    public SqlNode processView(String dbName, String tableName) {
        Table table = this.getMscOrThrow().getTable(dbName, tableName);
        if (table == null) {
            throw new RuntimeException(String.format("Unknown table %s.%s", dbName, tableName));
        }
        return this.processViewOrTable(table);
    }

    public SqlNode processSql(String sql) {
        return this.process(sql, null);
    }

    SqlNode process(String sql, @Nullable Table hiveView) {
        ParseDriver pd = new ParseDriver();
        try {
            ASTNode root = pd.parse(sql);
            return this.processAST(root, hiveView);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private SqlNode processAST(ASTNode node, @Nullable Table hiveView) {
        ParseContext ctx = new ParseContext(hiveView);
        return (SqlNode)this.visit(node, ctx);
    }

    @Override
    protected SqlNode visitTabAlias(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 1 ? 1 : 0) != 0);
        return (SqlNode)sqlNodes.get(0);
    }

    @Override
    protected SqlNode visitLateralView(ASTNode node, ParseContext ctx) {
        return this.visitLateralViewInternal(node, ctx, false);
    }

    @Override
    protected SqlNode visitLateralViewOuter(ASTNode node, ParseContext ctx) {
        return this.visitLateralViewInternal(node, ctx, true);
    }

    private SqlNode visitLateralViewInternal(ASTNode node, ParseContext ctx, boolean isOuter) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 2 && sqlNodes.get(0) instanceof SqlNodeList ? 1 : 0) != 0);
        SqlNode rightNode = ((SqlNodeList)sqlNodes.get(0)).get(0);
        Preconditions.checkState((boolean)(rightNode instanceof SqlCall));
        SqlCall aliasCall = (SqlCall)rightNode;
        Preconditions.checkState((boolean)(aliasCall.getOperator() instanceof SqlAsOperator));
        List aliasOperands = aliasCall.getOperandList();
        Preconditions.checkState((aliasOperands.size() == 3 && aliasOperands.get(0) instanceof SqlCall ? 1 : 0) != 0);
        SqlCall unnestCall = (SqlCall)aliasOperands.get(0);
        SqlNode unnestOperand = unnestCall.operand(0);
        SqlNode colNode = aliasCall.operand(2);
        if (isOuter) {
            SqlCall operandIsNull = SqlStdOperatorTable.IS_NOT_NULL.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestOperand});
            SqlCall emptyArray = SqlStdOperatorTable.GREATER_THAN.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlStdOperatorTable.CARDINALITY.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestOperand}), SqlLiteral.createExactNumeric((String)"0", (SqlParserPos)SqlParserPos.ZERO)});
            SqlCall ifCondition = SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, new SqlNode[]{operandIsNull, emptyArray});
            SqlCall arrOfNull = SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO)});
            HiveFunction hiveIfFunction = this.functionResolver.tryResolve("if", false, null, 1);
            SqlCall ifFunctionCall = hiveIfFunction.createCall((SqlNode)SqlLiteral.createCharString((String)"if", (SqlParserPos)SqlParserPos.ZERO), (List<SqlNode>)ImmutableList.of((Object)ifCondition, (Object)unnestOperand, (Object)arrOfNull), null);
            unnestCall = HiveExplodeOperator.EXPLODE.createCall(SqlParserPos.ZERO, new SqlNode[]{ifFunctionCall});
        }
        unnestCall = HiveExplodeOperator.EXPLODE.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestCall.operand(0), (SqlNode)aliasOperands.get(2)})});
        SqlCall unnestAlias = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, new SqlNode[]{unnestCall, (SqlNode)aliasOperands.get(1), (SqlNode)aliasOperands.get(2)});
        SqlSelect rightSelect = new SqlSelect(SqlParserPos.ZERO, null, new SqlNodeList((Collection)ImmutableList.of((Object)SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO)), SqlParserPos.ZERO), (SqlNode)unnestAlias, null, null, null, null, null, null, null);
        SqlCall lateralCall = SqlStdOperatorTable.LATERAL.createCall(SqlParserPos.ZERO, new SqlNode[]{rightSelect});
        aliasCall = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, new SqlNode[]{lateralCall, (SqlNode)aliasOperands.get(1), (SqlNode)aliasOperands.get(2)});
        SqlJoin joinNode = new SqlJoin(SqlParserPos.ZERO, (SqlNode)sqlNodes.get(1), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), JoinType.COMMA.symbol(SqlParserPos.ZERO), (SqlNode)aliasCall, JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
        return joinNode;
    }

    @Override
    protected SqlNode visitLeftSemiJoin(ASTNode node, ParseContext ctx) {
        throw new RuntimeException(String.format("%s, %s, %s", node.getType(), node.getText(), node.dump()));
    }

    @Override
    protected SqlNode visitCrossJoin(ASTNode node, ParseContext ctx) {
        throw new RuntimeException(String.format("%s, %s, %s", node.getType(), node.getText(), node.dump()));
    }

    @Override
    protected SqlNode visitFullOuterJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.FULL);
    }

    @Override
    protected SqlNode visitRightOuterJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.RIGHT);
    }

    @Override
    protected SqlNode visitJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.INNER);
    }

    @Override
    protected SqlNode visitLeftOuterJoin(ASTNode node, ParseContext ctx) {
        return this.processJoin(node, ctx, JoinType.LEFT);
    }

    private SqlNode processJoin(ASTNode node, ParseContext ctx, JoinType joinType) {
        JoinConditionType conditionType;
        List children = this.visitChildren(node, ctx);
        Preconditions.checkState((children.size() == 2 || children.size() == 3 ? 1 : 0) != 0);
        SqlNode condition = null;
        if (children.size() == 2) {
            conditionType = JoinConditionType.NONE;
        } else {
            conditionType = JoinConditionType.ON;
            condition = (SqlNode)children.get(2);
        }
        return new SqlJoin(SqlParserPos.ZERO, (SqlNode)children.get(0), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), joinType.symbol(SqlParserPos.ZERO), (SqlNode)children.get(1), conditionType.symbol(SqlParserPos.ZERO), condition);
    }

    @Override
    protected SqlNode visitFalse(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitTrue(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitNullToken(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitLimit(ASTNode node, ParseContext ctx) {
        ctx.fetch = (SqlNode)this.visitChildren(node, ctx).get(0);
        return ctx.fetch;
    }

    @Override
    protected SqlNode visitUnion(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.UNION_ALL, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitNumber(ASTNode node, ParseContext ctx) {
        String strval = node.getText();
        return SqlLiteral.createExactNumeric((String)strval, (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitAllColRef(ASTNode node, ParseContext ctx) {
        return SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitHaving(ASTNode node, ParseContext ctx) {
        Preconditions.checkState((((ArrayList)node.getChildren()).size() == 1 ? 1 : 0) != 0);
        ctx.having = (SqlNode)this.visit((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        return ctx.having;
    }

    @Override
    protected SqlNode visitWhere(ASTNode node, ParseContext ctx) {
        Preconditions.checkState((((ArrayList)node.getChildren()).size() == 1 ? 1 : 0) != 0);
        ctx.where = (SqlNode)this.visit((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        return ctx.where;
    }

    @Override
    protected SqlNode visitSortColNameDesc(ASTNode node, ParseContext ctx) {
        return this.visitSortColName(node, ctx, true);
    }

    @Override
    protected SqlNode visitSortColNameAsc(ASTNode node, ParseContext ctx) {
        return this.visitSortColName(node, ctx, false);
    }

    private SqlNode visitSortColName(ASTNode node, ParseContext ctx, boolean descending) {
        List children = this.visitChildren(node, ctx);
        Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0);
        if (!descending) {
            return (SqlNode)children.get(0);
        }
        return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.DESC, new SqlNode[]{(SqlNode)children.get(0)}, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitOrderBy(ASTNode node, ParseContext ctx) {
        List orderByCols = this.visitChildren(node, ctx);
        ctx.orderBy = new SqlNodeList(orderByCols, SqlParserPos.ZERO);
        return ctx.orderBy;
    }

    @Override
    protected SqlNode visitGroupBy(ASTNode node, ParseContext ctx) {
        List grpCols = this.visitChildren(node, ctx);
        ctx.grpBy = new SqlNodeList(grpCols, SqlParserPos.ZERO);
        return ctx.grpBy;
    }

    @Override
    protected SqlNode visitOperator(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        if (((ArrayList)children).size() == 1) {
            return this.visitUnaryOperator(node, ctx);
        }
        if (((ArrayList)children).size() == 2) {
            return this.visitBinaryOperator(node, ctx);
        }
        throw new RuntimeException(String.format("Unhandled AST operator: %s with > 2 children, tree: %s", node.getText(), node.dump()));
    }

    private SqlNode visitUnaryOperator(ASTNode node, ParseContext ctx) {
        SqlNode operand = (SqlNode)this.visit((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        SqlOperator operator = this.functionResolver.resolveUnaryOperator(node.getText());
        return operator.createCall(SqlParserPos.ZERO, new SqlNode[]{operand});
    }

    private SqlNode visitBinaryOperator(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 2 ? 1 : 0) != 0);
        return this.functionResolver.resolveBinaryOperator(node.getText()).createCall(SqlParserPos.ZERO, sqlNodes);
    }

    @Override
    protected SqlNode visitDotOperator(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes != null && sqlNodes.size() == 2 ? 1 : 0) != 0);
        if (sqlNodes.get(0) instanceof SqlIdentifier) {
            SqlIdentifier left = (SqlIdentifier)sqlNodes.get(0);
            SqlIdentifier right = (SqlIdentifier)sqlNodes.get(1);
            Iterable names = Iterables.concat((Iterable)left.names, (Iterable)right.names);
            return new SqlIdentifier((List)ImmutableList.copyOf((Iterable)names), SqlParserPos.ZERO);
        }
        return FunctionFieldReferenceOperator.DOT.createCall(SqlParserPos.ZERO, sqlNodes);
    }

    @Override
    protected SqlNode visitLParen(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes.size() == 2 ? 1 : 0) != 0);
        return SqlStdOperatorTable.ITEM.createCall(SqlParserPos.ZERO, sqlNodes);
    }

    @Override
    protected SqlNode visitFunctionStar(ASTNode node, ParseContext ctx) {
        ASTNode functionNode = (ASTNode)((ArrayList)node.getChildren()).get(0);
        List functions = SqlStdOperatorTable.instance().getOperatorList().stream().filter(f -> functionNode.getText().equalsIgnoreCase(f.getName())).collect(Collectors.toList());
        Preconditions.checkState((functions.size() == 1 ? 1 : 0) != 0);
        return new SqlBasicCall((SqlOperator)functions.get(0), new SqlNode[]{new SqlIdentifier("", SqlParserPos.ZERO)}, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitFunctionDistinct(ASTNode node, ParseContext ctx) {
        return this.visitFunctionInternal(node, ctx, SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO));
    }

    @Override
    protected SqlNode visitFunction(ASTNode node, ParseContext ctx) {
        return this.visitFunctionInternal(node, ctx, null);
    }

    private SqlNode visitFunctionInternal(ASTNode node, ParseContext ctx, SqlLiteral quantifier) {
        List children = node.getChildren();
        Preconditions.checkState((((ArrayList)children).size() > 0 ? 1 : 0) != 0);
        ASTNode functionNode = (ASTNode)((ArrayList)children).get(0);
        String functionName = functionNode.getText();
        List sqlOperands = this.visitChildren(children, ctx);
        HiveFunction hiveFunction = this.functionResolver.tryResolve(functionName, false, ctx.hiveTable.orElse(null), sqlOperands.size() - 1);
        return hiveFunction.createCall((SqlNode)sqlOperands.get(0), sqlOperands.subList(1, sqlOperands.size()), quantifier);
    }

    @Override
    protected SqlNode visitSelectExpr(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        if (sqlNodes.size() == 1) {
            return (SqlNode)sqlNodes.get(0);
        }
        if (sqlNodes.size() == 2) {
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        if (sqlNodes.size() == 3) {
            SqlNode[] nodes = new SqlNode[]{(SqlNode)sqlNodes.get(0), (SqlNode)sqlNodes.get(2), (SqlNode)sqlNodes.get(1)};
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, nodes, SqlParserPos.ZERO);
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitSelectDistinct(ASTNode node, ParseContext ctx) {
        ctx.keywords = new SqlNodeList((Collection)ImmutableList.of((Object)SqlSelectKeyword.DISTINCT.symbol(SqlParserPos.ZERO)), SqlParserPos.ZERO);
        return this.visitSelect(node, ctx);
    }

    @Override
    protected SqlNode visitSelect(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        ctx.selects = new SqlNodeList(sqlNodes, SqlParserPos.ZERO);
        return ctx.selects;
    }

    @Override
    protected SqlNode visitTabRefNode(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        Preconditions.checkState((sqlNodes != null && !sqlNodes.isEmpty() ? 1 : 0) != 0);
        if (sqlNodes.size() == 1) {
            return (SqlNode)sqlNodes.get(0);
        }
        if (sqlNodes.size() == 2) {
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitTabnameNode(ASTNode node, ParseContext ctx) {
        List sqlNodes = this.visitChildren(node, ctx);
        List names = sqlNodes.stream().map(s -> ((SqlIdentifier)s).names).flatMap(Collection::stream).collect(Collectors.toList());
        if (names.size() == 1) {
            if (!this.config.defaultDBName.isEmpty()) {
                names.add(0, this.config.defaultDBName);
            }
            if (!this.config.catalogName.isEmpty()) {
                names.add(0, this.config.catalogName);
            }
        } else if (names.size() == 2 && !this.config.catalogName.isEmpty()) {
            names.add(0, this.config.catalogName);
        }
        return new SqlIdentifier(names, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitSubqueryOp(ASTNode node, ParseContext ctx) {
        throw new UnhandledASTTokenException(node);
    }

    private SqlOperator getSubQueryOp(ASTNode node, ParseContext ctx) {
        Preconditions.checkState((((ArrayList)node.getChildren()).size() == 1 ? 1 : 0) != 0, (Object)node.dump());
        String opName = ((ASTNode)((ArrayList)node.getChildren()).get(0)).getText();
        if (opName.equalsIgnoreCase("in")) {
            return SqlStdOperatorTable.IN;
        }
        if (opName.equalsIgnoreCase("exists")) {
            return SqlStdOperatorTable.EXISTS;
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitSubqueryExpr(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        Preconditions.checkState((((ArrayList)children).size() >= 2 ? 1 : 0) != 0);
        SqlOperator op = this.getSubQueryOp((ASTNode)((ArrayList)node.getChildren()).get(0), ctx);
        SqlNode subQuery = (SqlNode)this.visit((ASTNode)((ArrayList)children).get(1), ctx);
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>();
        operands.add(subQuery);
        if (((ArrayList)children).size() == 3) {
            SqlNode lhs = (SqlNode)this.visit((ASTNode)((ArrayList)children).get(2), ctx);
            operands.add(0, lhs);
        }
        return new SqlBasicCall(op, operands.toArray(new SqlNode[0]), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitSubquery(ASTNode node, ParseContext ctx) {
        ParseContext subQueryContext = new ParseContext(ctx.getHiveTable().orElse(null));
        List sqlNodes = this.visitChildren(node, subQueryContext);
        if (sqlNodes.size() == 1) {
            return (SqlNode)sqlNodes.get(0);
        }
        if (sqlNodes.size() == 2) {
            return new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, sqlNodes.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        }
        throw new UnhandledASTTokenException(node);
    }

    @Override
    protected SqlNode visitFrom(ASTNode node, ParseContext ctx) {
        List children = this.visitChildren(node, ctx);
        if (children.size() == 1) {
            ctx.from = (SqlNode)children.get(0);
            return (SqlNode)children.get(0);
        }
        throw new UnsupportedASTException(node.dump());
    }

    @Override
    protected SqlNode visitIdentifier(ASTNode node, ParseContext ctx) {
        return new SqlIdentifier(node.getText(), SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitStringLiteral(ASTNode node, ParseContext ctx) {
        String text = node.getText();
        Preconditions.checkState((text.length() >= 2 ? 1 : 0) != 0);
        return SqlLiteral.createCharString((String)text.substring(1, text.length() - 1), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitBigintLiteral(ASTNode node, ParseContext ctx) {
        String text = node.getText();
        Preconditions.checkState((text.length() >= 2 ? 1 : 0) != 0);
        return SqlLiteral.createExactNumeric((String)text.substring(0, text.length() - 1), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitDateLiteral(ASTNode node, ParseContext ctx) {
        String text = node.getText();
        Preconditions.checkState((text.length() >= 2 ? 1 : 0) != 0);
        return SqlLiteral.createCharString((String)text.substring(1, text.length() - 1), (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitQueryNode(ASTNode node, ParseContext ctx) {
        List children = node.getChildren();
        Preconditions.checkState((children != null && !((ArrayList)children).isEmpty() ? 1 : 0) != 0);
        ParseContext qc = new ParseContext(ctx.getHiveTable().orElse(null));
        List sqlNodes = this.visitChildren(node, qc);
        return new SqlSelect(SqlParserPos.ZERO, qc.keywords, qc.selects, qc.from, qc.where, qc.grpBy, qc.having, null, qc.orderBy, null, qc.fetch);
    }

    @Override
    protected SqlNode visitNil(ASTNode node, ParseContext ctx) {
        return (SqlNode)this.visitChildren(node, ctx).get(0);
    }

    @Override
    protected SqlNode visitBoolean(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.BOOLEAN);
    }

    @Override
    protected SqlNode visitInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.INTEGER);
    }

    @Override
    protected SqlNode visitSmallInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.SMALLINT);
    }

    @Override
    protected SqlNode visitBigInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.BIGINT);
    }

    @Override
    protected SqlNode visitTinyInt(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.TINYINT);
    }

    @Override
    protected SqlNode visitFloat(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.FLOAT);
    }

    @Override
    protected SqlNode visitDouble(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.DOUBLE);
    }

    @Override
    protected SqlNode visitVarchar(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.VARCHAR);
    }

    @Override
    protected SqlNode visitChar(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.CHAR);
    }

    @Override
    protected SqlNode visitString(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.VARCHAR);
    }

    @Override
    protected SqlNode visitBinary(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.BINARY);
    }

    @Override
    protected SqlNode visitDecimal(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.DECIMAL);
    }

    @Override
    protected SqlNode visitDate(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.DATE);
    }

    @Override
    protected SqlNode visitTimestamp(ASTNode node, ParseContext ctx) {
        return this.createBasicTypeSpec(SqlTypeName.TIMESTAMP);
    }

    @Override
    protected SqlNode visitIsNull(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createCharString((String)"is null", (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitIsNotNull(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createCharString((String)"is not null", (SqlParserPos)SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitKeywordLiteral(ASTNode node, ParseContext ctx) {
        return SqlLiteral.createCharString((String)node.getText(), (SqlParserPos)SqlParserPos.ZERO);
    }

    private SqlDataTypeSpec createBasicTypeSpec(SqlTypeName type) {
        SqlBasicTypeNameSpec typeNameSpec = new SqlBasicTypeNameSpec(type, SqlParserPos.ZERO);
        return new SqlDataTypeSpec((SqlTypeNameSpec)typeNameSpec, SqlParserPos.ZERO);
    }

    @Override
    protected SqlNode visitTableTokOrCol(ASTNode node, ParseContext ctx) {
        return (SqlNode)this.visitChildren(node, ctx).get(0);
    }

    private HiveMetastoreClient getMscOrThrow() {
        if (this.hiveMetastoreClient == null) {
            throw new RuntimeException("Hive metastore client is required to access table");
        }
        return this.hiveMetastoreClient;
    }

    class ParseContext {
        private final Optional<Table> hiveTable;
        SqlNodeList keywords;
        SqlNode from;
        SqlNodeList selects;
        SqlNode where;
        SqlNodeList grpBy;
        SqlNode having;
        SqlNode fetch;
        SqlNodeList orderBy;

        ParseContext(Table hiveTable) {
            this.hiveTable = Optional.ofNullable(hiveTable);
        }

        Optional<Table> getHiveTable() {
            return this.hiveTable;
        }
    }

    public static class Config {
        private String catalogName = "";
        private String defaultDBName = "";

        public Config setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Config setDefaultDB(String defaultDBName) {
            this.defaultDBName = defaultDBName;
            return this;
        }
    }
}

