/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile;

import io.trino.rcfile.ColumnEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.stream.Collectors;

public interface RcFileEncoding {
    public ColumnEncoding booleanEncoding(Type var1);

    public ColumnEncoding byteEncoding(Type var1);

    public ColumnEncoding shortEncoding(Type var1);

    public ColumnEncoding intEncoding(Type var1);

    public ColumnEncoding longEncoding(Type var1);

    public ColumnEncoding decimalEncoding(Type var1);

    public ColumnEncoding floatEncoding(Type var1);

    public ColumnEncoding doubleEncoding(Type var1);

    public ColumnEncoding stringEncoding(Type var1);

    public ColumnEncoding binaryEncoding(Type var1);

    public ColumnEncoding dateEncoding(Type var1);

    public ColumnEncoding timestampEncoding(TimestampType var1);

    public ColumnEncoding listEncoding(Type var1, ColumnEncoding var2);

    public ColumnEncoding mapEncoding(Type var1, ColumnEncoding var2, ColumnEncoding var3);

    public ColumnEncoding structEncoding(Type var1, List<ColumnEncoding> var2);

    default public ColumnEncoding getEncoding(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return this.booleanEncoding(type);
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return this.byteEncoding(type);
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return this.shortEncoding(type);
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return this.intEncoding(type);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return this.longEncoding(type);
        }
        if (type instanceof DecimalType) {
            return this.decimalEncoding(type);
        }
        if (RealType.REAL.equals((Object)type)) {
            return this.floatEncoding(type);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return this.doubleEncoding(type);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return this.stringEncoding(type);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return this.binaryEncoding(type);
        }
        if (DateType.DATE.equals((Object)type)) {
            return this.dateEncoding(type);
        }
        if (type instanceof TimestampType) {
            return this.timestampEncoding((TimestampType)type);
        }
        if (type instanceof ArrayType) {
            ColumnEncoding elementType = this.getEncoding((Type)type.getTypeParameters().get(0));
            return this.listEncoding(type, elementType);
        }
        if (type instanceof MapType) {
            ColumnEncoding keyType = this.getEncoding((Type)type.getTypeParameters().get(0));
            ColumnEncoding valueType = this.getEncoding((Type)type.getTypeParameters().get(1));
            return this.mapEncoding(type, keyType, valueType);
        }
        if (type instanceof RowType) {
            return this.structEncoding(type, type.getTypeParameters().stream().map(this::getEncoding).collect(Collectors.toList()));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }
}

