/*
 * Decompiled with CFR 0.152.
 */
package io.trino.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.rcfile.ColumnData;
import io.trino.rcfile.EncodeOutput;
import io.trino.rcfile.text.TextColumnEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateEncoding
implements TextColumnEncoding {
    private static final DateTimeFormatter HIVE_DATE_PARSER = ISODateTimeFormat.date().withZoneUTC();
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public DateEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        this.encodeValue(block, position, output);
    }

    private void encodeValue(Block block, int position, SliceOutput output) {
        long days = this.type.getLong(block, position);
        long millis = TimeUnit.DAYS.toMillis(days);
        this.buffer.setLength(0);
        HIVE_DATE_PARSER.printTo(this.buffer, millis);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.type.writeLong(builder, (long)DateEncoding.parseDate(slice, offset, length));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeLong(builder, (long)DateEncoding.parseDate(slice, offset, length));
    }

    private static int parseDate(Slice slice, int offset, int length) {
        long millis = HIVE_DATE_PARSER.parseMillis(slice.toStringAscii(offset, length));
        return Math.toIntExact(TimeUnit.MILLISECONDS.toDays(millis));
    }
}

