/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc.internal;

import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.HashSet;

@NotThreadSafe
public abstract class InUseStateAggregator<T> {
    private final HashSet<T> inUseObjects = new HashSet();

    public final void updateObjectInUse(T object, boolean inUse) {
        int origSize = this.inUseObjects.size();
        if (inUse) {
            this.inUseObjects.add(object);
            if (origSize == 0) {
                this.handleInUse();
            }
        } else {
            boolean removed = this.inUseObjects.remove(object);
            if (removed && origSize == 1) {
                this.handleNotInUse();
            }
        }
    }

    public final boolean isInUse() {
        return !this.inUseObjects.isEmpty();
    }

    protected abstract void handleInUse();

    protected abstract void handleNotInUse();
}

