/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonGenerator;
import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonParser;
import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonProcessingException;
import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonToken;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.EncryptionAgent;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.EncryptionData;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.JsonUtilities;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.WrappedContentKey;
import java.io.IOException;
import java.io.StringWriter;

class BlobEncryptionData
extends EncryptionData {
    private String encryptionMode;

    BlobEncryptionData() {
    }

    public String getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize() throws IOException {
        StringWriter strWriter = new StringWriter();
        JsonGenerator generator = Utility.getJsonGenerator(strWriter);
        try {
            generator.writeStartObject();
            generator.writeStringField("EncryptionMode", "FullBlob");
            this.serialize(generator);
            generator.writeEndObject();
        }
        finally {
            generator.close();
        }
        return strWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlobEncryptionData deserialize(String inputData) throws JsonProcessingException, IOException {
        JsonParser parser = Utility.getJsonParser(inputData);
        BlobEncryptionData data = new BlobEncryptionData();
        try {
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                parser.nextToken();
                if (name.equals("EncryptionMode")) {
                    data.setEncryptionMode(parser.getValueAsString());
                } else if (name.equals("WrappedContentKey")) {
                    data.setWrappedContentKey(WrappedContentKey.deserialize(parser));
                } else if (name.equals("EncryptionAgent")) {
                    data.setEncryptionAgent(EncryptionAgent.deserialize(parser));
                } else if (name.equals("ContentEncryptionIV")) {
                    data.setContentEncryptionIV(parser.getBinaryValue());
                } else if (name.equals("KeyWrappingMetadata")) {
                    data.setKeyWrappingMetadata(BlobEncryptionData.deserializeKeyWrappingMetadata(parser));
                } else {
                    BlobEncryptionData.consumeJsonObject(parser);
                }
                parser.nextToken();
            }
            JsonUtilities.assertIsEndObjectJsonToken(parser);
        }
        finally {
            parser.close();
        }
        return data;
    }
}

