/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.core;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.htrace.core.SpanId;
import io.trino.hadoop.$internal.htrace.core.TimelineAnnotation;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@.JsonSerialize(using=SpanSerializer.class)
public interface Span {
    public void stop();

    public long getStartTimeMillis();

    public long getStopTimeMillis();

    public long getAccumulatedMillis();

    public boolean isRunning();

    public String getDescription();

    public SpanId getSpanId();

    @Deprecated
    public Span child(String var1);

    public String toString();

    public SpanId[] getParents();

    public void setParents(SpanId[] var1);

    public void addKVAnnotation(String var1, String var2);

    public void addTimelineAnnotation(String var1);

    public Map<String, String> getKVAnnotations();

    public List<TimelineAnnotation> getTimelineAnnotations();

    public String getTracerId();

    public void setTracerId(String var1);

    public String toJson();

    public static class SpanSerializer
    extends JsonSerializer<Span> {
        @Override
        public void serialize(Span span, JsonGenerator jgen, .SerializerProvider provider) throws IOException {
            List<TimelineAnnotation> timelineAnnotations;
            String tracerId;
            jgen.writeStartObject();
            if (span.getSpanId().isValid()) {
                jgen.writeStringField("a", span.getSpanId().toString());
            }
            if (span.getStartTimeMillis() != 0L) {
                jgen.writeNumberField("b", span.getStartTimeMillis());
            }
            if (span.getStopTimeMillis() != 0L) {
                jgen.writeNumberField("e", span.getStopTimeMillis());
            }
            if (!span.getDescription().isEmpty()) {
                jgen.writeStringField("d", span.getDescription());
            }
            if (!(tracerId = span.getTracerId()).isEmpty()) {
                jgen.writeStringField("r", tracerId);
            }
            jgen.writeArrayFieldStart("p");
            for (SpanId parent : span.getParents()) {
                jgen.writeString(parent.toString());
            }
            jgen.writeEndArray();
            Map<String, String> traceInfoMap = span.getKVAnnotations();
            if (!traceInfoMap.isEmpty()) {
                jgen.writeObjectFieldStart("n");
                Object[] keys = traceInfoMap.keySet().toArray(new String[traceInfoMap.size()]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    jgen.writeStringField((String)key, traceInfoMap.get(key));
                }
                jgen.writeEndObject();
            }
            if (!(timelineAnnotations = span.getTimelineAnnotations()).isEmpty()) {
                jgen.writeArrayFieldStart("t");
                for (TimelineAnnotation tl : timelineAnnotations) {
                    jgen.writeStartObject();
                    jgen.writeNumberField("t", tl.getTime());
                    jgen.writeStringField("m", tl.getMessage());
                    jgen.writeEndObject();
                }
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
    }
}

