/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ser.std;

import io.trino.hadoop.;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.SerializationFeature;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.trino.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> type, Boolean useTimestamp, DateFormat customFormat) {
        super(type);
        this._useTimestamp = useTimestamp;
        this._customFormat = customFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        .JsonFormat.Value format;
        if (property != null && (format = prov.getAnnotationIntrospector().findFormat(property.getMember())) != null) {
            if (format.getShape().isNumeric()) {
                return this.withFormat(Boolean.TRUE, null);
            }
            Boolean asNumber = format.getShape() == .JsonFormat.Shape.STRING ? Boolean.FALSE : null;
            TimeZone tz = format.getTimeZone();
            if (format.hasPattern()) {
                String pattern = format.getPattern();
                Locale loc = format.hasLocale() ? format.getLocale() : prov.getLocale();
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = prov.getTimeZone();
                }
                df.setTimeZone(tz);
                return this.withFormat(asNumber, df);
            }
            if (tz != null) {
                DateFormat df = prov.getConfig().getDateFormat();
                if (df.getClass() == StdDateFormat.class) {
                    Locale loc = format.hasLocale() ? format.getLocale() : prov.getLocale();
                    df = StdDateFormat.getISO8601Format(tz, loc);
                } else {
                    df = (DateFormat)df.clone();
                    df.setTimeZone(tz);
                }
                return this.withFormat(asNumber, df);
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty(T value) {
        return value == null || this._timestamp(value) == 0L;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._asTimestamp(provider) ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._acceptJsonFormatVisitor(visitor, typeHint, this._asTimestamp(visitor.getProvider()));
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    protected boolean _asTimestamp(SerializerProvider provider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._customFormat == null) {
            return provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return false;
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint, boolean asNumber) throws JsonMappingException {
        if (asNumber) {
            JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
            if (v2 != null) {
                v2.numberType(JsonParser.NumberType.LONG);
                v2.format(JsonValueFormat.UTC_MILLISEC);
            }
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }
}

