/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonIgnore;
import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.hadoop.$internal.com.fasterxml.jackson.core.JsonProcessingException;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.trino.hadoop.$internal.com.fasterxml.jackson.databind.ObjectWriter;
import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.com.google.common.collect.ImmutableList;
import io.trino.hadoop.$internal.com.google.common.collect.Lists;
import io.trino.hadoop.$internal.com.google.common.primitives.Doubles;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SlowDiskTracker {
    public static final Logger LOG = LoggerFactory.getLogger(SlowDiskTracker.class);
    private long reportValidityMs;
    private final Timer timer;
    private static final ObjectWriter WRITER = new ObjectMapper().writer();
    private static final int MAX_DISKS_TO_REPORT = 5;
    private static final String DATANODE_DISK_SEPARATOR = ":";
    private final long reportGenerationIntervalMs;
    private volatile long lastUpdateTime;
    private AtomicBoolean isUpdateInProgress = new AtomicBoolean(false);
    private final Map<String, DiskLatency> diskIDLatencyMap;
    private volatile ArrayList<DiskLatency> slowDisksReport = Lists.newArrayList();
    private volatile ArrayList<DiskLatency> oldSlowDisksCheck;

    public SlowDiskTracker(Configuration conf, Timer timer) {
        this.timer = timer;
        this.lastUpdateTime = timer.monotonicNow();
        this.diskIDLatencyMap = new ConcurrentHashMap<String, DiskLatency>();
        this.reportGenerationIntervalMs = conf.getTimeDuration("dfs.datanode.outliers.report.interval", "30m", TimeUnit.MILLISECONDS);
        this.reportValidityMs = this.reportGenerationIntervalMs * 3L;
    }

    @VisibleForTesting
    public static String getSlowDiskIDForReport(String datanodeID, String slowDisk) {
        return datanodeID + DATANODE_DISK_SEPARATOR + slowDisk;
    }

    public void addSlowDiskReport(String dataNodeID, SlowDiskReports dnSlowDiskReport) {
        Map<String, Map<SlowDiskReports.DiskOp, Double>> slowDisks = dnSlowDiskReport.getSlowDisks();
        long now = this.timer.monotonicNow();
        for (Map.Entry<String, Map<SlowDiskReports.DiskOp, Double>> slowDiskEntry : slowDisks.entrySet()) {
            String diskID = SlowDiskTracker.getSlowDiskIDForReport(dataNodeID, slowDiskEntry.getKey());
            Map<SlowDiskReports.DiskOp, Double> latencies = slowDiskEntry.getValue();
            DiskLatency diskLatency = new DiskLatency(diskID, latencies, now);
            this.diskIDLatencyMap.put(diskID, diskLatency);
        }
        this.checkAndUpdateReportIfNecessary();
    }

    private void checkAndUpdateReportIfNecessary() {
        long now = this.timer.monotonicNow();
        if (now - this.lastUpdateTime > this.reportGenerationIntervalMs) {
            this.updateSlowDiskReportAsync(now);
        }
    }

    @VisibleForTesting
    public void updateSlowDiskReportAsync(final long now) {
        if (this.isUpdateInProgress.compareAndSet(false, true)) {
            this.lastUpdateTime = now;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SlowDiskTracker.this.slowDisksReport = SlowDiskTracker.this.getSlowDisks(SlowDiskTracker.this.diskIDLatencyMap, 5, now);
                    SlowDiskTracker.this.cleanUpOldReports(now);
                    SlowDiskTracker.this.isUpdateInProgress.set(false);
                }
            }).start();
        }
    }

    private ArrayList<DiskLatency> getSlowDisks(Map<String, DiskLatency> reports, int numDisks, long now) {
        if (reports.isEmpty()) {
            return new ArrayList<DiskLatency>(ImmutableList.of());
        }
        PriorityQueue<DiskLatency> topNReports = new PriorityQueue<DiskLatency>(reports.size(), new Comparator<DiskLatency>(){

            @Override
            public int compare(DiskLatency o1, DiskLatency o2) {
                return Doubles.compare(o1.getMaxLatency(), o2.getMaxLatency());
            }
        });
        ArrayList<DiskLatency> oldSlowDiskIDs = Lists.newArrayList();
        for (Map.Entry<String, DiskLatency> entry : reports.entrySet()) {
            DiskLatency diskLatency = entry.getValue();
            if (now - diskLatency.timestamp < this.reportValidityMs) {
                if (topNReports.size() < numDisks) {
                    topNReports.add(diskLatency);
                    continue;
                }
                if (!(topNReports.peek().getMaxLatency() < diskLatency.getMaxLatency())) continue;
                topNReports.poll();
                topNReports.add(diskLatency);
                continue;
            }
            oldSlowDiskIDs.add(diskLatency);
        }
        this.oldSlowDisksCheck = oldSlowDiskIDs;
        return Lists.newArrayList(topNReports);
    }

    public String getSlowDiskReportAsJsonString() {
        try {
            if (this.slowDisksReport.isEmpty()) {
                return null;
            }
            return WRITER.writeValueAsString(this.slowDisksReport);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Failed to serialize statistics" + e);
            return null;
        }
    }

    private void cleanUpOldReports(long now) {
        if (this.oldSlowDisksCheck != null) {
            for (DiskLatency oldDiskLatency : this.oldSlowDisksCheck) {
                this.diskIDLatencyMap.remove(oldDiskLatency.getSlowDiskID(), oldDiskLatency);
            }
        }
        this.oldSlowDisksCheck = null;
    }

    @VisibleForTesting
    ArrayList<DiskLatency> getSlowDisksReport() {
        return this.slowDisksReport;
    }

    @VisibleForTesting
    long getReportValidityMs() {
        return this.reportValidityMs;
    }

    @VisibleForTesting
    void setReportValidityMs(long reportValidityMs) {
        this.reportValidityMs = reportValidityMs;
    }

    public static class DiskLatency {
        @JsonProperty(value="SlowDiskID")
        private final String slowDiskID;
        @JsonProperty(value="Latencies")
        private final Map<SlowDiskReports.DiskOp, Double> latencyMap;
        @JsonIgnore
        private long timestamp;

        public DiskLatency(@JsonProperty(value="SlowDiskID") String slowDiskID, @JsonProperty(value="Latencies") Map<SlowDiskReports.DiskOp, Double> latencyMap) {
            this.slowDiskID = slowDiskID;
            this.latencyMap = latencyMap;
        }

        public DiskLatency(String slowDiskID, Map<SlowDiskReports.DiskOp, Double> latencyMap, long timestamp) {
            this.slowDiskID = slowDiskID;
            this.latencyMap = latencyMap;
            this.timestamp = timestamp;
        }

        String getSlowDiskID() {
            return this.slowDiskID;
        }

        double getMaxLatency() {
            double maxLatency = 0.0;
            for (double latency : this.latencyMap.values()) {
                if (!(latency > maxLatency)) continue;
                maxLatency = latency;
            }
            return maxLatency;
        }

        Double getLatency(SlowDiskReports.DiskOp op) {
            return this.latencyMap.get((Object)op);
        }
    }
}

