/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.utils;

import com.qubole.rubix.bookkeeper.utils.ShellExec;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import com.qubole.rubix.spi.utils.DataSizeUnits;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class DiskUtils {
    private static Log log = LogFactory.getLog((String)DiskUtils.class.getName());

    private DiskUtils() {
    }

    public static void clearDirectory(String path) throws IOException {
        String cmd = "rm -rf " + path;
        ShellExec se = new ShellExec(cmd);
        log.debug((Object)("Running: " + cmd));
        ShellExec.CommandResult cr = se.runCmd();
    }

    public static int getCacheSizeMB(Configuration conf) {
        HashMap<Integer, String> diskMap = CacheUtil.getCacheDiskPathsMap(conf);
        String cacheDirSuffix = CacheConfig.getCacheDataDirSuffix(conf);
        long cacheSize = 0L;
        for (int disk = 0; disk < diskMap.size(); ++disk) {
            long cacheDirSize = DiskUtils.getDirectorySizeInMB(new File((String)diskMap.get(disk) + cacheDirSuffix));
            if (cacheDirSize == -1L) {
                return -1;
            }
            cacheSize += cacheDirSize;
        }
        return (int)cacheSize;
    }

    public static long getDirectorySizeInMB(File dirname) {
        String cmd = "du -s " + dirname.toString();
        StringBuffer output = new StringBuffer();
        try {
            String[] env = new String[]{"BLOCKSIZE=1024"};
            Process p = Runtime.getRuntime().exec(cmd, env);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("Exception while calculating the size of the folder %s with exception : %s", dirname.toString(), e.toString()));
        }
        try {
            return DataSizeUnits.KILOBYTES.toMB(Long.parseLong(output.toString().split("\\s+")[0]));
        }
        catch (NumberFormatException e) {
            log.warn((Object)String.format("Unable to calculate size of directory %s, du output returned: %s", dirname, output.toString()));
            return -1L;
        }
    }
}

