/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.bookkeeper.validation;

import com.google.shaded.shaded.common.util.concurrent.AbstractScheduledService;
import com.qubole.rubix.bookkeeper.validation.FileValidatorResult;
import com.qubole.rubix.bookkeeper.validation.FileValidatorVisitor;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.CacheUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class FileValidator
extends AbstractScheduledService {
    private static final Log log = LogFactory.getLog(FileValidator.class);
    private final Configuration conf;
    private final ScheduledExecutorService validationExecutor;
    private final int validationInterval;
    private FileValidatorResult validatorResult = new FileValidatorResult();

    public FileValidator(Configuration conf, ScheduledExecutorService validationExecutor) {
        this.conf = conf;
        this.validationExecutor = validationExecutor;
        this.validationInterval = CacheConfig.getCachingValidationInterval(conf);
    }

    @Override
    protected ScheduledExecutorService executor() {
        return this.validationExecutor;
    }

    @Override
    protected void runOneIteration() throws Exception {
        this.validatorResult = this.validateCache();
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule(0L, this.validationInterval, TimeUnit.MILLISECONDS);
    }

    public boolean didValidationSucceed() {
        return this.validatorResult.getFailureCount() == 0;
    }

    private FileValidatorResult validateCache() {
        int maxDisks = CacheConfig.getCacheMaxDisks(this.conf);
        FileValidatorResult allDisksResult = new FileValidatorResult();
        for (int diskIndex = 0; diskIndex < maxDisks; ++diskIndex) {
            FileValidatorVisitor validatorVisitor = new FileValidatorVisitor(this.conf);
            Path diskCachePath = Paths.get(CacheUtil.getDirPath(diskIndex, this.conf), CacheConfig.getCacheDataDirSuffix(this.conf));
            try {
                Files.walkFileTree(diskCachePath, validatorVisitor);
            }
            catch (IOException e) {
                log.error((Object)"Encountered issue while verifying files", (Throwable)e);
            }
            allDisksResult.addResult(validatorVisitor.getResult());
        }
        if (allDisksResult.getFailureCount() > 0) {
            log.error((Object)"Validation Error!");
            log.error((Object)"The following cache files do not have an associated metadata file:");
            for (String fileName : allDisksResult.getFilesWithoutMD()) {
                log.error((Object)String.format("-- %s", fileName));
            }
        }
        return allDisksResult;
    }
}

