/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi.utils;

public enum DataSizeUnits {
    BYTES{

        @Override
        public long toBytes(long size) {
            return size;
        }

        @Override
        public long toKB(long size) {
            return size / 1024L;
        }

        @Override
        public long toMB(long size) {
            return this.toKB(size) / 1024L;
        }

        @Override
        public long toGB(long size) {
            return this.toMB(size) / 1024L;
        }
    }
    ,
    KILOBYTES{

        @Override
        public long toBytes(long size) {
            return size * 1024L;
        }

        @Override
        public long toKB(long size) {
            return size;
        }

        @Override
        public long toMB(long size) {
            return size / 1024L;
        }

        @Override
        public long toGB(long size) {
            return this.toMB(size) / 1024L;
        }
    }
    ,
    MEGABYTES{

        @Override
        public long toBytes(long size) {
            return KILOBYTES.toBytes(this.toKB(size));
        }

        @Override
        public long toKB(long size) {
            return size * 1024L;
        }

        @Override
        public long toMB(long size) {
            return size;
        }

        @Override
        public long toGB(long size) {
            return size / 1024L;
        }
    }
    ,
    GIGABYTES{

        @Override
        public long toBytes(long size) {
            return MEGABYTES.toBytes(this.toMB(size));
        }

        @Override
        public long toKB(long size) {
            return MEGABYTES.toKB(this.toMB(size));
        }

        @Override
        public long toMB(long size) {
            return size * 1024L;
        }

        @Override
        public long toGB(long size) {
            return size;
        }
    };


    public long toBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toKB(long size) {
        throw new AbstractMethodError();
    }

    public long toMB(long size) {
        throw new AbstractMethodError();
    }

    public long toGB(long size) {
        throw new AbstractMethodError();
    }
}

