/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope;
import com.linkedin.coral.com.esri.core.geometry.Envelope1D;
import com.linkedin.coral.com.esri.core.geometry.VertexDescription;
import com.linkedin.coral.com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class EnvSrlzr
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[] attribs;
    int descriptionBitMask;

    public Object readResolve() throws ObjectStreamException {
        Envelope env = null;
        if (this.descriptionBitMask == -1) {
            return null;
        }
        try {
            VertexDescription vd = VertexDescriptionDesignerImpl.getVertexDescription(this.descriptionBitMask);
            env = new Envelope(vd);
            if (this.attribs != null) {
                env.setCoords(this.attribs[0], this.attribs[1], this.attribs[2], this.attribs[3]);
                int index = 4;
                int n = vd.getAttributeCount();
                for (int i = 1; i < n; ++i) {
                    int semantics = vd.getSemantics(i);
                    int comps = VertexDescription.getComponentCount(semantics);
                    for (int ord = 0; ord < comps; ++ord) {
                        env.setInterval(semantics, ord, this.attribs[index++], this.attribs[index++]);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot read geometry from stream");
        }
        return env;
    }

    public void setGeometryByValue(Envelope env) throws ObjectStreamException {
        try {
            this.attribs = null;
            if (env == null) {
                this.descriptionBitMask = -1;
            }
            VertexDescription vd = env.getDescription();
            this.descriptionBitMask = vd.m_semanticsBitArray;
            if (env.isEmpty()) {
                return;
            }
            this.attribs = new double[vd.getTotalComponentCount() * 2];
            this.attribs[0] = env.getXMin();
            this.attribs[1] = env.getYMin();
            this.attribs[2] = env.getXMax();
            this.attribs[3] = env.getYMax();
            int index = 4;
            int n = vd.getAttributeCount();
            for (int i = 1; i < n; ++i) {
                int semantics = vd.getSemantics(i);
                int comps = VertexDescription.getComponentCount(semantics);
                for (int ord = 0; ord < comps; ++ord) {
                    Envelope1D e = env.queryInterval(semantics, ord);
                    this.attribs[index++] = e.vmin;
                    this.attribs[index++] = e.vmax;
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Cannot serialize this geometry");
        }
    }
}

