/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope;
import com.linkedin.coral.com.esri.core.geometry.Envelope1D;
import com.linkedin.coral.com.esri.core.geometry.Envelope2D;
import com.linkedin.coral.com.esri.core.geometry.Envelope3D;
import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.MultiPathImpl;
import com.linkedin.coral.com.esri.core.geometry.MultiVertexGeometry;
import com.linkedin.coral.com.esri.core.geometry.Point;
import com.linkedin.coral.com.esri.core.geometry.Point2D;
import com.linkedin.coral.com.esri.core.geometry.Point3D;
import com.linkedin.coral.com.esri.core.geometry.Segment;
import com.linkedin.coral.com.esri.core.geometry.SegmentIterator;
import com.linkedin.coral.com.esri.core.geometry.Transformation2D;
import com.linkedin.coral.com.esri.core.geometry.Transformation3D;
import com.linkedin.coral.com.esri.core.geometry.VertexDescription;
import java.io.Serializable;

public abstract class MultiPath
extends MultiVertexGeometry
implements Serializable {
    MultiPathImpl m_impl;

    @Override
    public VertexDescription getDescription() {
        return this.m_impl.getDescription();
    }

    @Override
    public void assignVertexDescription(VertexDescription src) {
        this.m_impl.assignVertexDescription(src);
    }

    @Override
    public void mergeVertexDescription(VertexDescription src) {
        this.m_impl.mergeVertexDescription(src);
    }

    @Override
    public void addAttribute(int semantics) {
        this.m_impl.addAttribute(semantics);
    }

    @Override
    public void dropAttribute(int semantics) {
        this.m_impl.dropAttribute(semantics);
    }

    @Override
    public void dropAllAttributes() {
        this.m_impl.dropAllAttributes();
    }

    @Override
    public int getPointCount() {
        return this.m_impl.getPointCount();
    }

    @Override
    public Point getPoint(int index) {
        return this.m_impl.getPoint(index);
    }

    @Override
    public void setPoint(int index, Point point) {
        this.m_impl.setPoint(index, point);
    }

    @Override
    public boolean isEmpty() {
        return this.m_impl.isEmptyImpl();
    }

    @Override
    public double calculateArea2D() {
        return this.m_impl.calculateArea2D();
    }

    @Override
    public double calculateLength2D() {
        return this.m_impl.calculateLength2D();
    }

    public double calculatePathLength2D(int pathIndex) {
        return this.m_impl.calculatePathLength2D(pathIndex);
    }

    @Override
    public double getAttributeAsDbl(int semantics, int index, int ordinate) {
        return this.m_impl.getAttributeAsDbl(semantics, index, ordinate);
    }

    @Override
    public int getAttributeAsInt(int semantics, int index, int ordinate) {
        return this.m_impl.getAttributeAsInt(semantics, index, ordinate);
    }

    @Override
    public void setAttribute(int semantics, int index, int ordinate, double value) {
        this.m_impl.setAttribute(semantics, index, ordinate, value);
    }

    @Override
    public void setAttribute(int semantics, int index, int ordinate, int value) {
        this.m_impl.setAttribute(semantics, index, ordinate, value);
    }

    @Override
    public Point2D getXY(int index) {
        return this.m_impl.getXY(index);
    }

    @Override
    public void getXY(int index, Point2D pt) {
        this.m_impl.getXY(index, pt);
    }

    @Override
    public void setXY(int index, Point2D pt) {
        this.m_impl.setXY(index, pt);
    }

    @Override
    Point3D getXYZ(int index) {
        return this.m_impl.getXYZ(index);
    }

    @Override
    void setXYZ(int index, Point3D pt) {
        this.m_impl.setXYZ(index, pt);
    }

    @Override
    public void queryEnvelope(Envelope env) {
        this.m_impl.queryEnvelope(env);
    }

    @Override
    public void queryEnvelope2D(Envelope2D env) {
        this.m_impl.queryEnvelope2D(env);
    }

    public void queryPathEnvelope2D(int pathIndex, Envelope2D env) {
        this.m_impl.queryPathEnvelope2D(pathIndex, env);
    }

    @Override
    void queryEnvelope3D(Envelope3D env) {
        this.m_impl.queryEnvelope3D(env);
    }

    public void queryLooseEnvelope(Envelope2D env) {
        this.m_impl.queryLooseEnvelope2D(env);
    }

    void queryLooseEnvelope(Envelope3D env) {
        this.m_impl.queryLooseEnvelope3D(env);
    }

    @Override
    public Envelope1D queryInterval(int semantics, int ordinate) {
        return this.m_impl.queryInterval(semantics, ordinate);
    }

    @Override
    public void copyTo(Geometry dst) {
        if (this.getType() != dst.getType()) {
            throw new IllegalArgumentException();
        }
        this.m_impl.copyTo((Geometry)dst._getImpl());
    }

    @Override
    public Geometry getBoundary() {
        return this.m_impl.getBoundary();
    }

    @Override
    public void queryCoordinates(Point2D[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    public void queryCoordinates(Point2D[] dst, int dstSize, int beginIndex, int endIndex) {
        this.m_impl.queryCoordinates(dst, dstSize, beginIndex, endIndex);
    }

    @Override
    void queryCoordinates(Point3D[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    @Override
    public void queryCoordinates(Point[] dst) {
        this.m_impl.queryCoordinates(dst);
    }

    boolean hasNonLinearSegments() {
        return this.m_impl.hasNonLinearSegments();
    }

    public int getSegmentCount() {
        return this.m_impl.getSegmentCount();
    }

    public int getSegmentCount(int pathIndex) {
        int segCount = this.getPathSize(pathIndex);
        if (!this.isClosedPath(pathIndex)) {
            --segCount;
        }
        return segCount;
    }

    public void add(MultiPath src, boolean bReversePaths) {
        this.m_impl.add((MultiPathImpl)src._getImpl(), bReversePaths);
    }

    public void addPath(MultiPath src, int srcPathIndex, boolean bForward) {
        this.m_impl.addPath((MultiPathImpl)src._getImpl(), srcPathIndex, bForward);
    }

    void addPath(Point2D[] points, int count, boolean bForward) {
        this.m_impl.addPath(points, count, bForward);
    }

    public void addSegmentsFromPath(MultiPath src, int srcPathIndex, int srcSegmentFrom, int srcSegmentCount, boolean bStartNewPath) {
        this.m_impl.addSegmentsFromPath((MultiPathImpl)src._getImpl(), srcPathIndex, srcSegmentFrom, srcSegmentCount, bStartNewPath);
    }

    public void addSegment(Segment segment, boolean bStartNewPath) {
        this.m_impl.addSegment(segment, bStartNewPath);
    }

    public void reverseAllPaths() {
        this.m_impl.reverseAllPaths();
    }

    public void reversePath(int pathIndex) {
        this.m_impl.reversePath(pathIndex);
    }

    public void removePath(int pathIndex) {
        this.m_impl.removePath(pathIndex);
    }

    public void insertPath(int pathIndex, MultiPath src, int srcPathIndex, boolean bForward) {
        this.m_impl.insertPath(pathIndex, (MultiPathImpl)src._getImpl(), srcPathIndex, bForward);
    }

    void insertPath(int pathIndex, Point2D[] points, int pointsOffset, int count, boolean bForward) {
        this.m_impl.insertPath(pathIndex, points, pointsOffset, count, bForward);
    }

    public void insertPoints(int pathIndex, int beforePointIndex, MultiPath src, int srcPathIndex, int srcPointIndexFrom, int srcPointCount, boolean bForward) {
        this.m_impl.insertPoints(pathIndex, beforePointIndex, (MultiPathImpl)src._getImpl(), srcPathIndex, srcPointIndexFrom, srcPointCount, bForward);
    }

    void insertPoints(int pathIndex, int beforePointIndex, Point2D[] src, int srcPointIndexFrom, int srcPointCount, boolean bForward) {
        this.m_impl.insertPoints(pathIndex, beforePointIndex, src, srcPointIndexFrom, srcPointCount, bForward);
    }

    void insertPoint(int pathIndex, int beforePointIndex, Point2D pt) {
        this.m_impl.insertPoint(pathIndex, beforePointIndex, pt);
    }

    public void insertPoint(int pathIndex, int beforePointIndex, Point pt) {
        this.m_impl.insertPoint(pathIndex, beforePointIndex, pt);
    }

    public void removePoint(int pathIndex, int pointIndex) {
        this.m_impl.removePoint(pathIndex, pointIndex);
    }

    public int getPathCount() {
        return this.m_impl.getPathCount();
    }

    public int getPathSize(int pathIndex) {
        return this.m_impl.getPathSize(pathIndex);
    }

    public int getPathStart(int pathIndex) {
        return this.m_impl.getPathStart(pathIndex);
    }

    public int getPathEnd(int pathIndex) {
        return this.m_impl.getPathEnd(pathIndex);
    }

    public int getPathIndexFromPointIndex(int pointIndex) {
        return this.m_impl.getPathIndexFromPointIndex(pointIndex);
    }

    public void startPath(double x, double y) {
        this.m_impl.startPath(x, y);
    }

    void startPath(Point2D point) {
        this.m_impl.startPath(point);
    }

    void startPath(Point3D point) {
        this.m_impl.startPath(point);
    }

    public void startPath(Point point) {
        this.m_impl.startPath(point);
    }

    public void lineTo(double x, double y) {
        this.m_impl.lineTo(x, y);
    }

    void lineTo(Point2D endPoint) {
        this.m_impl.lineTo(endPoint);
    }

    void lineTo(Point3D endPoint) {
        this.m_impl.lineTo(endPoint);
    }

    public void lineTo(Point endPoint) {
        this.m_impl.lineTo(endPoint);
    }

    void bezierTo(Point2D controlPoint1, Point2D controlPoint2, Point2D endPoint) {
        this.m_impl.bezierTo(controlPoint1, controlPoint2, endPoint);
    }

    public void closePathWithLine() {
        this.m_impl.closePathWithLine();
    }

    void closePathWithBezier(Point2D controlPoint1, Point2D controlPoint2) {
        this.m_impl.closePathWithBezier(controlPoint1, controlPoint2);
    }

    void closePathWithArc() {
        throw new RuntimeException("not implemented");
    }

    public void closeAllPaths() {
        this.m_impl.closeAllPaths();
    }

    public boolean isClosedPath(int pathIndex) {
        return this.m_impl.isClosedPath(pathIndex);
    }

    public boolean isClosedPathInXYPlane(int pathIndex) {
        return this.m_impl.isClosedPathInXYPlane(pathIndex);
    }

    boolean hasNonLinearSegments(int pathIndex) {
        return this.m_impl.hasNonLinearSegments(pathIndex);
    }

    public void addEnvelope(Envelope2D envSrc, boolean bReverse) {
        this.m_impl.addEnvelope(envSrc, bReverse);
    }

    public void addEnvelope(Envelope envSrc, boolean bReverse) {
        this.m_impl.addEnvelope(envSrc, bReverse);
    }

    public SegmentIterator querySegmentIterator() {
        return new SegmentIterator(this.m_impl.querySegmentIterator());
    }

    public SegmentIterator querySegmentIteratorAtVertex(int startVertexIndex) {
        return new SegmentIterator(this.m_impl.querySegmentIteratorAtVertex(startVertexIndex));
    }

    @Override
    public void setEmpty() {
        this.m_impl.setEmpty();
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        this.m_impl.applyTransformation(transform);
    }

    @Override
    void applyTransformation(Transformation3D transform) {
        this.m_impl.applyTransformation(transform);
    }

    @Override
    protected Object _getImpl() {
        return this.m_impl;
    }

    public int hashCode() {
        return this.m_impl.hashCode();
    }

    @Override
    public void getPointByVal(int index, Point outPoint) {
        this.m_impl.getPointByVal(index, outPoint);
    }

    @Override
    public void setPointByVal(int index, Point point) {
        this.m_impl.setPointByVal(index, point);
    }

    @Override
    public int getStateFlag() {
        return this.m_impl.getStateFlag();
    }

    @Override
    public void replaceNaNs(int semantics, double value) {
        this.m_impl.replaceNaNs(semantics, value);
    }
}

