/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Envelope;
import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.Line;
import com.linkedin.coral.com.esri.core.geometry.MultiPoint;
import com.linkedin.coral.com.esri.core.geometry.OperatorCentroid2D;
import com.linkedin.coral.com.esri.core.geometry.Point;
import com.linkedin.coral.com.esri.core.geometry.Point2D;
import com.linkedin.coral.com.esri.core.geometry.Polygon;
import com.linkedin.coral.com.esri.core.geometry.Polyline;
import com.linkedin.coral.com.esri.core.geometry.ProgressTracker;

public class OperatorCentroid2DLocal
extends OperatorCentroid2D {
    @Override
    public Point2D execute(Geometry geometry, ProgressTracker progressTracker) {
        if (geometry.isEmpty()) {
            return null;
        }
        Geometry.Type geometryType = geometry.getType();
        switch (geometryType) {
            case Point: {
                return ((Point)geometry).getXY();
            }
            case Line: {
                return OperatorCentroid2DLocal.computeLineCentroid((Line)geometry);
            }
            case Envelope: {
                return ((Envelope)geometry).getCenterXY();
            }
            case MultiPoint: {
                return OperatorCentroid2DLocal.computePointsCentroid((MultiPoint)geometry);
            }
            case Polyline: {
                return OperatorCentroid2DLocal.computePolylineCentroid((Polyline)geometry);
            }
            case Polygon: {
                return OperatorCentroid2DLocal.computePolygonCentroid((Polygon)geometry);
            }
        }
        throw new UnsupportedOperationException("Unexpected geometry type: " + (Object)((Object)geometryType));
    }

    private static Point2D computeLineCentroid(Line line) {
        return new Point2D((line.getEndX() - line.getStartX()) / 2.0, (line.getEndY() - line.getStartY()) / 2.0);
    }

    private static Point2D computePointsCentroid(MultiPoint multiPoint) {
        double xSum = 0.0;
        double ySum = 0.0;
        int pointCount = multiPoint.getPointCount();
        Point2D point2D = new Point2D();
        for (int i = 0; i < pointCount; ++i) {
            multiPoint.getXY(i, point2D);
            xSum += point2D.x;
            ySum += point2D.y;
        }
        return new Point2D(xSum / (double)pointCount, ySum / (double)pointCount);
    }

    private static Point2D computePolylineCentroid(Polyline polyline) {
        double xSum = 0.0;
        double ySum = 0.0;
        double weightSum = 0.0;
        Point2D startPoint = new Point2D();
        Point2D endPoint = new Point2D();
        for (int i = 0; i < polyline.getPathCount(); ++i) {
            polyline.getXY(polyline.getPathStart(i), startPoint);
            polyline.getXY(polyline.getPathEnd(i) - 1, endPoint);
            double dx = endPoint.x - startPoint.x;
            double dy = endPoint.y - startPoint.y;
            double length = Math.sqrt(dx * dx + dy * dy);
            weightSum += length;
            xSum += (startPoint.x + endPoint.x) * length / 2.0;
            ySum += (startPoint.y + endPoint.y) * length / 2.0;
        }
        return new Point2D(xSum / weightSum, ySum / weightSum);
    }

    private static Point2D computePolygonCentroid(Polygon polygon) {
        int pathCount = polygon.getPathCount();
        if (pathCount == 1) {
            return OperatorCentroid2DLocal.getPolygonSansHolesCentroid(polygon);
        }
        double xSum = 0.0;
        double ySum = 0.0;
        double areaSum = 0.0;
        for (int i = 0; i < pathCount; ++i) {
            int startIndex = polygon.getPathStart(i);
            int endIndex = polygon.getPathEnd(i);
            Polygon sansHoles = OperatorCentroid2DLocal.getSubPolygon(polygon, startIndex, endIndex);
            Point2D centroid = OperatorCentroid2DLocal.getPolygonSansHolesCentroid(sansHoles);
            double area = sansHoles.calculateArea2D();
            xSum += centroid.x * area;
            ySum += centroid.y * area;
            areaSum += area;
        }
        return new Point2D(xSum / areaSum, ySum / areaSum);
    }

    private static Polygon getSubPolygon(Polygon polygon, int startIndex, int endIndex) {
        Polyline boundary = new Polyline();
        boundary.startPath(polygon.getPoint(startIndex));
        for (int i = startIndex + 1; i < endIndex; ++i) {
            Point current = polygon.getPoint(i);
            boundary.lineTo(current);
        }
        Polygon newPolygon = new Polygon();
        newPolygon.add(boundary, false);
        return newPolygon;
    }

    private static Point2D getPolygonSansHolesCentroid(Polygon polygon) {
        int pointCount = polygon.getPointCount();
        double xSum = 0.0;
        double ySum = 0.0;
        double signedArea = 0.0;
        Point2D current = new Point2D();
        Point2D next = new Point2D();
        for (int i = 0; i < pointCount; ++i) {
            polygon.getXY(i, current);
            polygon.getXY((i + 1) % pointCount, next);
            double ladder = current.x * next.y - next.x * current.y;
            xSum += (current.x + next.x) * ladder;
            ySum += (current.y + next.y) * ladder;
            signedArea += ladder / 2.0;
        }
        return new Point2D(xSum / (signedArea * 6.0), ySum / (signedArea * 6.0));
    }
}

