/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.GeometryCursor;
import com.linkedin.coral.com.esri.core.geometry.OperatorSimplifyLocalHelper;
import com.linkedin.coral.com.esri.core.geometry.ProgressTracker;
import com.linkedin.coral.com.esri.core.geometry.SpatialReference;

class OperatorSimplifyCursorOGC
extends GeometryCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReference m_spatialReference;
    ProgressTracker m_progressTracker;
    int m_index;
    boolean m_bForceSimplify;

    OperatorSimplifyCursorOGC(GeometryCursor geoms, SpatialReference spatialRef, boolean bForceSimplify, ProgressTracker progressTracker) {
        this.m_progressTracker = progressTracker;
        this.m_bForceSimplify = bForceSimplify;
        this.m_index = -1;
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_inputGeometryCursor = geoms;
        this.m_spatialReference = spatialRef;
    }

    @Override
    public Geometry next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            if (this.m_progressTracker != null && !this.m_progressTracker.progress(-1, -1)) {
                throw new RuntimeException("user_canceled");
            }
            return this.simplify(geometry);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    Geometry simplify(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException();
        }
        return OperatorSimplifyLocalHelper.simplifyOGC(geometry, this.m_spatialReference, this.m_bForceSimplify, this.m_progressTracker);
    }
}

