/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.VertexDescription;
import com.linkedin.coral.com.esri.core.geometry.VertexDescriptionHash;
import java.util.Arrays;

final class VertexDescriptionDesignerImpl {
    VertexDescriptionDesignerImpl() {
    }

    static VertexDescription getVertexDescription(int descriptionBitMask) {
        return VertexDescriptionHash.getInstance().FindOrAdd(descriptionBitMask);
    }

    static VertexDescription getMergedVertexDescription(VertexDescription descr1, VertexDescription descr2) {
        int mask = descr1.m_semanticsBitArray | descr2.m_semanticsBitArray;
        if ((mask & descr1.m_semanticsBitArray) == mask) {
            return descr1;
        }
        if ((mask & descr2.m_semanticsBitArray) == mask) {
            return descr2;
        }
        return VertexDescriptionDesignerImpl.getVertexDescription(mask);
    }

    static VertexDescription getMergedVertexDescription(VertexDescription descr, int semantics) {
        int mask = descr.m_semanticsBitArray | 1 << semantics;
        if ((mask & descr.m_semanticsBitArray) == mask) {
            return descr;
        }
        return VertexDescriptionDesignerImpl.getVertexDescription(mask);
    }

    static VertexDescription removeSemanticsFromVertexDescription(VertexDescription descr, int semanticsToRemove) {
        int mask = (descr.m_semanticsBitArray | 1 << semanticsToRemove) - (1 << semanticsToRemove);
        if (mask == descr.m_semanticsBitArray) {
            return descr;
        }
        return VertexDescriptionDesignerImpl.getVertexDescription(mask);
    }

    static VertexDescription getDefaultDescriptor2D() {
        return VertexDescriptionHash.getInstance().getVD2D();
    }

    static VertexDescription getDefaultDescriptor3D() {
        return VertexDescriptionHash.getInstance().getVD3D();
    }

    static int[] mapAttributes(VertexDescription src, VertexDescription dest) {
        int[] srcToDst = new int[src.getAttributeCount()];
        Arrays.fill(srcToDst, -1);
        int nsrc = src.getAttributeCount();
        for (int i = 0; i < nsrc; ++i) {
            srcToDst[i] = dest.getAttributeIndex(src.getSemantics(i));
        }
        return srcToDst;
    }
}

