/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.MemoryFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.Enumerables;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

public class EnumerableMatch
extends Match
implements EnumerableRel {
    public EnumerableMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        super(cluster, traitSet, input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    public static EnumerableMatch create(RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, RexNode interval) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE);
        return new EnumerableMatch(cluster, traitSet, input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableMatch(this.getCluster(), traitSet, inputs.get(0), this.rowType, this.pattern, this.strictStart, this.strictEnd, this.patternDefinitions, this.measures, this.after, this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel input = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, input, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), input.getRowType(), result.format);
        Expression inputExp = builder.append("input", result.block);
        PhysType inputPhysType = result.physType;
        PhysType keyPhysType = inputPhysType.project(this.partitionKeys.asList(), JavaRowFormat.LIST);
        ParameterExpression row_ = Expressions.parameter(inputPhysType.getJavaRowType(), "row_");
        Expression keySelector_ = builder.append("keySelector", inputPhysType.generateSelector(row_, this.partitionKeys.asList(), keyPhysType.getFormat()));
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = implementor.getTypeFactory().builder();
        this.measures.forEach((name, value) -> typeBuilder.add((String)name, value.getType()));
        PhysType emitType = PhysTypeImpl.of(implementor.getTypeFactory(), typeBuilder.build(), result.format);
        Expression matcher_ = this.implementMatcher(implementor, physType, builder, row_);
        Expression emitter_ = this.implementEmitter(implementor, emitType, physType);
        MaxHistoryFutureVisitor visitor = new MaxHistoryFutureVisitor();
        this.patternDefinitions.values().forEach(pd -> pd.accept(visitor));
        int history = visitor.getHistory();
        int future = visitor.getFuture();
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.MATCH.method, inputExp, keySelector_, matcher_, emitter_, Expressions.constant(history), Expressions.constant(future))));
        return implementor.result(emitType, builder.toBlock());
    }

    private Expression implementEmitter(EnumerableRelImplementor implementor, PhysType physType, PhysType inputPhysType) {
        ParameterExpression rows_ = Expressions.parameter(Types.of(List.class, new Type[]{inputPhysType.getJavaRowType()}), "rows");
        ParameterExpression rowStates_ = Expressions.parameter(List.class, "rowStates");
        ParameterExpression symbols_ = Expressions.parameter(List.class, "symbols");
        ParameterExpression match_ = Expressions.parameter(Integer.TYPE, "match");
        ParameterExpression consumer_ = Expressions.parameter(Consumer.class, "consumer");
        ParameterExpression row_ = Expressions.parameter(inputPhysType.getJavaRowType(), "row");
        BlockBuilder builder2 = new BlockBuilder();
        RexBuilder rexBuilder = new RexBuilder(implementor.getTypeFactory());
        RexProgramBuilder rexProgramBuilder = new RexProgramBuilder(inputPhysType.getRowType(), rexBuilder);
        for (Map.Entry entry : this.measures.entrySet()) {
            rexProgramBuilder.addProject((RexNode)entry.getValue(), (String)entry.getKey());
        }
        List<Expression> arguments = RexToLixTranslator.translateProjects(rexProgramBuilder.getProgram(), (JavaTypeFactory)this.getCluster().getTypeFactory(), implementor.getConformance(), builder2, physType, implementor.getRootExpression(), new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(row_, inputPhysType))), implementor.allCorrelateVariables);
        ParameterExpression result_ = Expressions.parameter(physType.getJavaRowType());
        builder2.add(Expressions.declare(16, result_, (Expression)Expressions.new_(physType.getJavaRowType())));
        for (int i = 0; i < arguments.size(); ++i) {
            builder2.add(Expressions.statement(Expressions.assign(physType.fieldReference(result_, i), arguments.get(i))));
        }
        builder2.add(Expressions.statement(Expressions.call((Expression)consumer_, BuiltInMethod.CONSUMER_ACCEPT.method, result_)));
        BlockBuilder builder = new BlockBuilder();
        builder.add(Expressions.forEach(row_, rows_, builder2.toBlock()));
        return Expressions.new_(Types.of(Enumerables.Emitter.class, new Type[0]), EnumUtils.NO_EXPRS, Expressions.list(EnumUtils.overridingMethodDecl(BuiltInMethod.EMITTER_EMIT.method, ImmutableList.of(rows_, rowStates_, symbols_, match_, consumer_), builder.toBlock())));
    }

    private Expression implementMatcher(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression row_) {
        Expression patternBuilder_ = builder.append("patternBuilder", Expressions.call(BuiltInMethod.PATTERN_BUILDER.method, new Expression[0]));
        Expression automaton_ = builder.append("automaton", Expressions.call(this.implementPattern(patternBuilder_, this.pattern), BuiltInMethod.PATTERN_TO_AUTOMATON.method, new Expression[0]));
        Expression matcherBuilder_ = builder.append("matcherBuilder", Expressions.call(BuiltInMethod.MATCHER_BUILDER.method, automaton_));
        BlockBuilder builder2 = new BlockBuilder();
        for (Map.Entry entry : this.patternDefinitions.entrySet()) {
            RexBuilder rexBuilder = new RexBuilder(implementor.getTypeFactory());
            RexProgramBuilder rexProgramBuilder = new RexProgramBuilder(physType.getRowType(), rexBuilder);
            rexProgramBuilder.addCondition((RexNode)entry.getValue());
            PrevInputGetter inputGetter1 = new PrevInputGetter(row_, physType);
            Expression condition = RexToLixTranslator.translateCondition(rexProgramBuilder.getProgram(), (JavaTypeFactory)this.getCluster().getTypeFactory(), builder2, inputGetter1, implementor.allCorrelateVariables, implementor.getConformance());
            builder2.add(Expressions.return_(null, condition));
            Expression predicate_ = this.implementPredicate(physType, row_, builder2.toBlock());
            matcherBuilder_ = Expressions.call(matcherBuilder_, BuiltInMethod.MATCHER_BUILDER_ADD.method, Expressions.constant(entry.getKey()), predicate_);
        }
        return builder.append("matcher", Expressions.call(matcherBuilder_, BuiltInMethod.MATCHER_BUILDER_BUILD.method, new Expression[0]));
    }

    private Expression implementPredicate(PhysType physType, ParameterExpression rows_, BlockStatement body) {
        ArrayList<MethodDeclaration> memberDeclarations = new ArrayList<MethodDeclaration>();
        ParameterExpression row_ = Expressions.parameter(Types.of(MemoryFactory.Memory.class, new Type[]{physType.getJavaRowType()}), "row_");
        Expressions.assign(row_, Expressions.call((Expression)rows_, BuiltInMethod.MEMORY_GET0.method, new Expression[0]));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.PREDICATE_TEST.method, ImmutableList.of(row_), body));
        ParameterExpression row0_ = Expressions.parameter(Object.class, "row");
        ParameterExpression rowsO_ = Expressions.parameter(Object.class, "rows");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add(Expressions.return_(null, Expressions.call((Expression)Expressions.parameter(Comparable.class, "this"), BuiltInMethod.PREDICATE_TEST.method, Expressions.convert_(row0_, Types.of(MemoryFactory.Memory.class, new Type[]{physType.getJavaRowType()})))));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.PREDICATE_TEST.method, ImmutableList.of(row0_), bridgeBody.toBlock()));
        return Expressions.new_(Types.of(Predicate.class, new Type[0]), EnumUtils.NO_EXPRS, memberDeclarations);
    }

    private Expression implementPattern(Expression patternBuilder_, RexNode pattern) {
        switch (pattern.getKind()) {
            case LITERAL: {
                String symbol = ((RexLiteral)pattern).getValueAs(String.class);
                return Expressions.call(patternBuilder_, BuiltInMethod.PATTERN_BUILDER_SYMBOL.method, Expressions.constant(symbol));
            }
            case PATTERN_CONCAT: {
                RexCall concat = (RexCall)pattern;
                for (Ord<RexNode> operand : Ord.zip(concat.operands)) {
                    patternBuilder_ = this.implementPattern(patternBuilder_, (RexNode)operand.e);
                    if (operand.i <= 0) continue;
                    patternBuilder_ = Expressions.call(patternBuilder_, BuiltInMethod.PATTERN_BUILDER_SEQ.method, new Expression[0]);
                }
                return patternBuilder_;
            }
        }
        throw new AssertionError((Object)("unknown kind: " + pattern));
    }

    private static class MaxHistoryFutureVisitor
    extends RexVisitorImpl<Void> {
        private int history;
        private int future;

        protected MaxHistoryFutureVisitor() {
            super(true);
        }

        public int getHistory() {
            return this.history;
        }

        public int getFuture() {
            return this.future;
        }

        @Override
        public Void visitCall(RexCall call) {
            call.operands.forEach(o -> o.accept(this));
            switch (call.op.kind) {
                case PREV: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(1);
                    int prev = operand.getValueAs(Integer.class);
                    this.history = Math.max(this.history, prev);
                    break;
                }
                case NEXT: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(1);
                    int next = operand.getValueAs(Integer.class);
                    this.future = Math.max(this.future, next);
                }
            }
            return null;
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            return null;
        }
    }

    static class PrevInputGetter
    implements RexToLixTranslator.InputGetter {
        private Expression offset;
        private final ParameterExpression row;
        private final Function<Expression, RexToLixTranslator.InputGetter> generator;
        private final PhysType physType;

        PrevInputGetter(ParameterExpression row, PhysType physType) {
            this.row = row;
            this.generator = e -> new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(e, physType)));
            this.physType = physType;
        }

        void setOffset(Expression offset) {
            this.offset = offset;
        }

        @Override
        public Expression field(BlockBuilder list, int index, Type storageType) {
            ParameterExpression row = Expressions.parameter(this.physType.getJavaRowType());
            ParameterExpression tmp = Expressions.parameter(Object.class);
            list.add(Expressions.declare(0, tmp, (Expression)Expressions.call((Expression)this.row, BuiltInMethod.MEMORY_GET1.method, this.offset)));
            list.add(Expressions.declare(0, row, (Expression)Expressions.convert_(tmp, this.physType.getJavaRowType())));
            list.add(Expressions.ifThen(Expressions.equal(tmp, Expressions.constant(null)), Expressions.return_(null, Expressions.constant(false))));
            return this.generator.apply(row).field(list, index, storageType);
        }
    }
}

