/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;

public class RelWriterImpl
implements RelWriter {
    protected final PrintWriter pw;
    private final SqlExplainLevel detailLevel;
    private final boolean withIdPrefix;
    protected final Spacer spacer = new Spacer();
    private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();

    public RelWriterImpl(PrintWriter pw) {
        this(pw, SqlExplainLevel.EXPPLAN_ATTRIBUTES, true);
    }

    public RelWriterImpl(PrintWriter pw, SqlExplainLevel detailLevel, boolean withIdPrefix) {
        this.pw = pw;
        this.detailLevel = detailLevel;
        this.withIdPrefix = withIdPrefix;
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        List<RelNode> inputs = rel.getInputs();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        if (!mq.isVisibleInExplain(rel, this.detailLevel)) {
            this.explainInputs(inputs);
            return;
        }
        StringBuilder s = new StringBuilder();
        this.spacer.spaces(s);
        if (this.withIdPrefix) {
            s.append(rel.getId()).append(":");
        }
        s.append(rel.getRelTypeName());
        if (this.detailLevel != SqlExplainLevel.NO_ATTRIBUTES) {
            int j = 0;
            for (Pair<String, Object> value : values) {
                if (value.right instanceof RelNode) continue;
                if (j++ == 0) {
                    s.append("(");
                } else {
                    s.append(", ");
                }
                s.append((String)value.left).append("=[").append(value.right).append("]");
            }
            if (j > 0) {
                s.append(")");
            }
        }
        switch (this.detailLevel) {
            case ALL_ATTRIBUTES: {
                s.append(": rowcount = ").append(mq.getRowCount(rel)).append(", cumulative cost = ").append(mq.getCumulativeCost(rel));
            }
        }
        switch (this.detailLevel) {
            case ALL_ATTRIBUTES: 
            case NON_COST_ATTRIBUTES: {
                if (this.withIdPrefix) break;
                s.append(", id = ").append(rel.getId());
            }
        }
        this.pw.println(s);
        this.spacer.add(2);
        this.explainInputs(inputs);
        this.spacer.subtract(2);
    }

    private void explainInputs(List<RelNode> inputs) {
        for (RelNode input : inputs) {
            input.explain(this);
        }
    }

    @Override
    public final void explain(RelNode rel, List<Pair<String, Object>> valueList) {
        this.explain_(rel, valueList);
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public RelWriter item(String term, Object value) {
        this.values.add(Pair.of(term, value));
        return this;
    }

    @Override
    public RelWriter done(RelNode node) {
        assert (this.checkInputsPresentInExplain(node));
        ImmutableList<Pair<String, Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, valuesCopy);
        this.pw.flush();
        return this;
    }

    private boolean checkInputsPresentInExplain(RelNode node) {
        int i = 0;
        if (this.values.size() > 0 && ((String)this.values.get((int)0).left).equals("subset")) {
            ++i;
        }
        for (RelNode input : node.getInputs()) {
            assert (this.values.get((int)i).right == input);
            ++i;
        }
        return true;
    }

    public String simple() {
        StringBuilder buf = new StringBuilder("(");
        for (Ord<Pair<String, Object>> ord : Ord.zip(this.values)) {
            if (ord.i > 0) {
                buf.append(", ");
            }
            buf.append((String)((Pair)ord.e).left).append("=[").append(((Pair)ord.e).right).append("]");
        }
        buf.append(")");
        return buf.toString();
    }
}

