/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.linkedin.coral.com.google.common.collect.ImmutableCollection;
import com.linkedin.coral.com.google.common.collect.ImmutableList;
import com.linkedin.coral.com.google.common.collect.ImmutableSetMultimap;
import com.linkedin.coral.com.google.common.collect.LinkedHashMultimap;
import com.linkedin.coral.com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;

public class JethroDataSqlDialect
extends SqlDialect {
    private final JethroInfo info;

    public JethroDataSqlDialect(SqlDialect.Context context) {
        super(context);
        this.info = context.jethroInfo();
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return node;
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case COUNT: 
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsFunction(SqlOperator operator, RelDataType type, List<RelDataType> paramTypes) {
        switch (operator.getKind()) {
            case IS_NOT_NULL: 
            case IS_NULL: 
            case AND: 
            case OR: 
            case NOT: 
            case BETWEEN: 
            case CASE: 
            case CAST: {
                return true;
            }
        }
        ImmutableCollection functions = this.info.supportedFunctions.get(operator.getName());
        if (functions != null) {
            for (JethroSupportedFunction f : functions) {
                if (!f.argumentsMatch(paramTypes)) continue;
                return true;
            }
        }
        LOGGER.debug("Unsupported function in jethro: " + operator + " with params " + paramTypes);
        return false;
    }

    @Override
    public boolean supportsOffsetFetch() {
        return false;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    public static JethroInfoCache createCache() {
        return new JethroInfoCacheImpl();
    }

    public static class JethroInfo {
        public static final JethroInfo EMPTY = new JethroInfo(ImmutableSetMultimap.of());
        private final ImmutableSetMultimap<String, JethroSupportedFunction> supportedFunctions;

        public JethroInfo(Multimap<String, JethroSupportedFunction> supportedFunctions) {
            this.supportedFunctions = ImmutableSetMultimap.copyOf(supportedFunctions);
        }
    }

    static class JethroSupportedFunction {
        private final List<SqlTypeName> operandTypes;

        JethroSupportedFunction(String name, String operands) {
            Objects.requireNonNull(name);
            ImmutableList.Builder b = ImmutableList.builder();
            for (String strType : operands.split(":")) {
                b.add((Object)this.parse(strType));
            }
            this.operandTypes = b.build();
        }

        private SqlTypeName parse(String strType) {
            switch (strType.toLowerCase(Locale.ROOT)) {
                case "bigint": 
                case "long": {
                    return SqlTypeName.BIGINT;
                }
                case "integer": 
                case "int": {
                    return SqlTypeName.INTEGER;
                }
                case "double": {
                    return SqlTypeName.DOUBLE;
                }
                case "float": {
                    return SqlTypeName.FLOAT;
                }
                case "string": {
                    return SqlTypeName.VARCHAR;
                }
                case "timestamp": {
                    return SqlTypeName.TIMESTAMP;
                }
            }
            return SqlTypeName.ANY;
        }

        boolean argumentsMatch(List<RelDataType> paramTypes) {
            if (paramTypes.size() != this.operandTypes.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.size(); ++i) {
                if (paramTypes.get(i).getSqlTypeName() == this.operandTypes.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static class JethroInfoCacheImpl
    implements JethroInfoCache {
        final Map<String, JethroInfo> map = new HashMap<String, JethroInfo>();

        private JethroInfoCacheImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JethroInfo get(DatabaseMetaData metaData) {
            try {
                assert ("JethroData".equals(metaData.getDatabaseProductName()));
                String productVersion = metaData.getDatabaseProductVersion();
                JethroInfoCacheImpl jethroInfoCacheImpl = this;
                synchronized (jethroInfoCacheImpl) {
                    JethroInfo info = this.map.get(productVersion);
                    if (info == null) {
                        Connection c = metaData.getConnection();
                        info = this.makeInfo(c);
                        this.map.put(productVersion, info);
                    }
                    return info;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create JethroDataDialect", e);
                throw new RuntimeException("Failed to create JethroDataDialect", e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private JethroInfo makeInfo(Connection jethroConnection) {
            try (Statement jethroStatement = jethroConnection.createStatement();){
                JethroInfo jethroInfo;
                block15: {
                    ResultSet functionsTupleSet = jethroStatement.executeQuery("show functions extended");
                    try {
                        LinkedHashMultimap<String, JethroSupportedFunction> supportedFunctions = LinkedHashMultimap.create();
                        while (functionsTupleSet.next()) {
                            String functionName = functionsTupleSet.getString(1);
                            String operandsType = functionsTupleSet.getString(3);
                            supportedFunctions.put(functionName, new JethroSupportedFunction(functionName, operandsType));
                        }
                        jethroInfo = new JethroInfo(supportedFunctions);
                        if (functionsTupleSet == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (functionsTupleSet != null) {
                            try {
                                functionsTupleSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    functionsTupleSet.close();
                }
                return jethroInfo;
            }
            catch (Exception e) {
                String msg = "Jethro server failed to execute 'show functions extended'";
                LOGGER.error("Jethro server failed to execute 'show functions extended'", e);
                throw new RuntimeException("Jethro server failed to execute 'show functions extended'; make sure your Jethro server is up to date", e);
            }
        }
    }

    public static interface JethroInfoCache {
        public JethroInfo get(DatabaseMetaData var1);
    }
}

