/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate.implicit;

import com.linkedin.coral.com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeAssignmentRules;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public abstract class AbstractTypeCoercion
implements TypeCoercion {
    protected SqlValidator validator;
    protected RelDataTypeFactory factory;

    AbstractTypeCoercion(SqlValidator validator) {
        Objects.requireNonNull(validator);
        this.validator = validator;
        this.factory = validator.getTypeFactory();
    }

    public RelDataTypeFactory getFactory() {
        return this.factory;
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    protected boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int index, RelDataType targetType) {
        SqlNode operand;
        if (RelDataTypeFactoryImpl.isJavaType(targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if (!this.needToCast(scope, operand = call.getOperandList().get(index), targetType)) {
            return false;
        }
        RelDataType targetType1 = this.syncAttributes(this.validator.deriveType(scope, operand), targetType);
        SqlNode desired = this.castTo(operand, targetType1);
        call.setOperand(index, desired);
        this.updateInferredType(desired, targetType1);
        return true;
    }

    protected boolean coerceColumnType(SqlValidatorScope scope, SqlNodeList nodeList, int index, RelDataType targetType) {
        if (RelDataTypeFactoryImpl.isJavaType(targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if (index >= nodeList.getList().size()) {
            return true;
        }
        SqlNode node = nodeList.get(index);
        if (node instanceof SqlIdentifier) {
            SqlIdentifier node1 = (SqlIdentifier)node;
            if (node1.isStar()) {
                return true;
            }
            if (DynamicRecordType.isDynamicStarColName(Util.last(node1.names))) {
                return false;
            }
        }
        if (node instanceof SqlCall) {
            SqlCall node2 = (SqlCall)node;
            if (node2.getOperator().kind == SqlKind.AS) {
                Object operand = node2.operand(0);
                if (!this.needToCast(scope, (SqlNode)operand, targetType)) {
                    return false;
                }
                RelDataType targetType2 = this.syncAttributes(this.validator.deriveType(scope, (SqlNode)operand), targetType);
                SqlNode casted = this.castTo((SqlNode)operand, targetType2);
                node2.setOperand(0, casted);
                this.updateInferredType(casted, targetType2);
                return true;
            }
        }
        if (!this.needToCast(scope, node, targetType)) {
            return false;
        }
        RelDataType targetType3 = this.syncAttributes(this.validator.deriveType(scope, node), targetType);
        SqlNode node3 = this.castTo(node, targetType3);
        nodeList.set(index, node3);
        this.updateInferredType(node3, targetType3);
        return true;
    }

    RelDataType syncAttributes(RelDataType type1, RelDataType targetType) {
        RelDataType targetType1 = targetType;
        if (type1 != null) {
            targetType1 = this.factory.createTypeWithNullability(targetType1, type1.isNullable());
            if (SqlTypeUtil.inCharOrBinaryFamilies(type1) && SqlTypeUtil.inCharOrBinaryFamilies(targetType)) {
                Charset charset1 = type1.getCharset();
                SqlCollation collation1 = type1.getCollation();
                if (charset1 != null && SqlTypeUtil.inCharFamily(targetType1)) {
                    targetType1 = this.factory.createTypeWithCharsetAndCollation(targetType1, charset1, collation1);
                }
            }
        }
        return targetType1;
    }

    protected boolean needToCast(SqlValidatorScope scope, SqlNode node1, RelDataType targetType) {
        RelDataType type1 = this.validator.deriveType(scope, node1);
        if (type1 == null) {
            return false;
        }
        if (targetType.getSqlTypeName() == type1.getSqlTypeName()) {
            return false;
        }
        if (targetType.getSqlTypeName() == SqlTypeName.ANY || type1.getSqlTypeName() == SqlTypeName.ANY) {
            return false;
        }
        if (targetType.getSqlTypeName() == SqlTypeName.VARCHAR && type1.getSqlTypeName() == SqlTypeName.CHAR || targetType.getSqlTypeName() == SqlTypeName.CHAR && type1.getSqlTypeName() == SqlTypeName.VARCHAR) {
            return false;
        }
        if (type1.getPrecedenceList().containsType(targetType) && SqlTypeUtil.isIntType(type1) && SqlTypeUtil.isIntType(targetType)) {
            return false;
        }
        return !SqlTypeUtil.equalSansNullability(this.factory, type1, targetType) && SqlTypeAssignmentRules.instance(true).canCastFrom(targetType.getSqlTypeName(), targetType.getSqlTypeName());
    }

    private SqlNode castTo(SqlNode node, RelDataType type) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(type).withNullable(type.isNullable()));
    }

    protected void updateInferredType(SqlNode node, RelDataType type) {
        this.validator.setValidatedNodeType(node, type);
        SqlValidatorNamespace namespace = this.validator.getNamespace(node);
        if (namespace != null) {
            namespace.setType(type);
        }
    }

    protected void updateInferredColumnType(SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType targetType1) {
        RelDataType rowType = this.validator.deriveType(scope, query);
        assert (rowType.isStruct());
        ArrayList<Pair<String, RelDataType>> fieldList = new ArrayList<Pair<String, RelDataType>>();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            RelDataTypeField field = rowType.getFieldList().get(i);
            String name = field.getName();
            RelDataType type = field.getType();
            RelDataType targetType = i == columnIndex ? targetType1 : type;
            fieldList.add(Pair.of(name, targetType));
        }
        this.updateInferredType(query, this.factory.createStructType(fieldList));
    }

    @Override
    public RelDataType getTightestCommonType(RelDataType type1, RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1.equals(type2) || type1.isNullable() != type2.isNullable() && this.factory.createTypeWithNullability(type1, type2.isNullable()).equals(type2)) {
            return this.factory.createTypeWithNullability(type1, type1.isNullable() || type2.isNullable());
        }
        if (SqlTypeUtil.isNull(type1)) {
            return type2;
        }
        if (SqlTypeUtil.isNull(type2)) {
            return type1;
        }
        RelDataType resultType = null;
        if (SqlTypeUtil.isString(type1) && SqlTypeUtil.isString(type2)) {
            resultType = this.factory.leastRestrictive(ImmutableList.of(type1, type2));
        }
        if (SqlTypeUtil.isNumeric(type1) && SqlTypeUtil.isNumeric(type2) && !SqlTypeUtil.isDecimal(type1) && !SqlTypeUtil.isDecimal(type2)) {
            resultType = this.factory.leastRestrictive(ImmutableList.of(type1, type2));
        }
        if (SqlTypeUtil.isDate(type1) && SqlTypeUtil.isTimestamp(type2)) {
            resultType = type2;
        }
        if (SqlTypeUtil.isDate(type2) && SqlTypeUtil.isTimestamp(type1)) {
            resultType = type1;
        }
        if (type1.isStruct() && type2.isStruct() && SqlTypeUtil.equalAsStructSansNullability(this.factory, type1, type2, this.validator.getCatalogReader().nameMatcher())) {
            ArrayList<RelDataType> fields = new ArrayList<RelDataType>();
            List<String> fieldNames = type1.getFieldNames();
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(type1.getFieldList(), type2.getFieldList())) {
                RelDataType leftType = ((RelDataTypeField)pair.left).getType();
                RelDataType rightType = ((RelDataTypeField)pair.right).getType();
                RelDataType dataType = this.getTightestCommonType(leftType, rightType);
                boolean isNullable = leftType.isNullable() || rightType.isNullable();
                fields.add(this.factory.createTypeWithNullability(dataType, isNullable));
            }
            return this.factory.createStructType(type1.getStructKind(), fields, fieldNames);
        }
        if (SqlTypeUtil.isArray(type1) && SqlTypeUtil.isArray(type2) && SqlTypeUtil.equalSansNullability(this.factory, type1, type2)) {
            resultType = this.factory.createTypeWithNullability(type1, type1.isNullable() || type2.isNullable());
        }
        if (SqlTypeUtil.isMap(type1) && SqlTypeUtil.isMap(type2) && SqlTypeUtil.equalSansNullability(this.factory, type1, type2)) {
            RelDataType keyType = this.getTightestCommonType(type1.getKeyType(), type2.getKeyType());
            RelDataType valType = this.getTightestCommonType(type1.getValueType(), type2.getValueType());
            resultType = this.factory.createMapType(keyType, valType);
        }
        return resultType;
    }

    private RelDataType promoteToVarChar(RelDataType type1, RelDataType type2) {
        RelDataType resultType = null;
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isCharacter(type2)) {
            return null;
        }
        if (SqlTypeUtil.isAtomic(type1) && SqlTypeUtil.isCharacter(type2)) {
            resultType = this.factory.createSqlType(SqlTypeName.VARCHAR);
        }
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isAtomic(type2)) {
            resultType = this.factory.createSqlType(SqlTypeName.VARCHAR);
        }
        return resultType;
    }

    @Override
    public RelDataType commonTypeForBinaryComparison(RelDataType type1, RelDataType type2) {
        SqlTypeName typeName1 = type1.getSqlTypeName();
        SqlTypeName typeName2 = type2.getSqlTypeName();
        if (typeName1 == null || typeName2 == null) {
            return null;
        }
        if (SqlTypeUtil.isString(type1) && SqlTypeUtil.isDatetime(type2) || SqlTypeUtil.isDatetime(type1) && SqlTypeUtil.isString(type2)) {
            return null;
        }
        if (SqlTypeUtil.isDate(type1) && SqlTypeUtil.isTimestamp(type2)) {
            return type2;
        }
        if (SqlTypeUtil.isDate(type2) && SqlTypeUtil.isTimestamp(type1)) {
            return type1;
        }
        if (SqlTypeUtil.isString(type1) && typeName2 == SqlTypeName.NULL) {
            return type1;
        }
        if (typeName1 == SqlTypeName.NULL && SqlTypeUtil.isString(type2)) {
            return type2;
        }
        if (SqlTypeUtil.isDecimal(type1) && SqlTypeUtil.isCharacter(type2) || SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isDecimal(type2)) {
            return SqlTypeUtil.getMaxPrecisionScaleDecimal(this.factory);
        }
        if (SqlTypeUtil.isBinary(type2) && SqlTypeUtil.isApproximateNumeric(type1) || SqlTypeUtil.isBinary(type1) && SqlTypeUtil.isApproximateNumeric(type2)) {
            return null;
        }
        if (SqlTypeUtil.isAtomic(type1) && SqlTypeUtil.isCharacter(type2)) {
            if (SqlTypeUtil.isTimestamp(type1)) {
                return null;
            }
            return type1;
        }
        if (SqlTypeUtil.isCharacter(type1) && SqlTypeUtil.isAtomic(type2)) {
            if (SqlTypeUtil.isTimestamp(type2)) {
                return null;
            }
            return type2;
        }
        return null;
    }

    @Override
    public RelDataType getWiderTypeForTwo(RelDataType type1, RelDataType type2, boolean stringPromotion) {
        RelDataType valType;
        RelDataType resultType = this.getTightestCommonType(type1, type2);
        if (null == resultType) {
            resultType = this.getWiderTypeForDecimal(type1, type2);
        }
        if (null == resultType && stringPromotion) {
            resultType = this.promoteToVarChar(type1, type2);
        }
        if (null == resultType && SqlTypeUtil.isArray(type1) && SqlTypeUtil.isArray(type2) && null != (valType = this.getWiderTypeForTwo(type1.getComponentType(), type2.getComponentType(), stringPromotion))) {
            resultType = this.factory.createArrayType(valType, -1L);
        }
        return resultType;
    }

    @Override
    public RelDataType getWiderTypeForDecimal(RelDataType type1, RelDataType type2) {
        if (!SqlTypeUtil.isDecimal(type1) && !SqlTypeUtil.isDecimal(type2)) {
            return null;
        }
        if (SqlTypeUtil.isNumeric(type1) && SqlTypeUtil.isNumeric(type2)) {
            return this.factory.leastRestrictive(ImmutableList.of(type1, type2));
        }
        return null;
    }

    @Override
    public RelDataType getWiderTypeFor(List<RelDataType> typeList, boolean stringPromotion) {
        assert (typeList.size() > 1);
        RelDataType resultType = typeList.get(0);
        List<RelDataType> target = stringPromotion ? this.partitionByCharacter(typeList) : typeList;
        for (RelDataType tp : target) {
            resultType = this.getWiderTypeForTwo(tp, resultType, stringPromotion);
            if (null != resultType) continue;
            return null;
        }
        return resultType;
    }

    private List<RelDataType> partitionByCharacter(List<RelDataType> types) {
        ArrayList<RelDataType> withCharacterTypes = new ArrayList<RelDataType>();
        ArrayList<RelDataType> nonCharacterTypes = new ArrayList<RelDataType>();
        for (RelDataType tp : types) {
            if (SqlTypeUtil.hasCharactor(tp)) {
                withCharacterTypes.add(tp);
                continue;
            }
            nonCharacterTypes.add(tp);
        }
        ArrayList<RelDataType> partitioned = new ArrayList<RelDataType>();
        partitioned.addAll(withCharacterTypes);
        partitioned.addAll(nonCharacterTypes);
        return partitioned;
    }

    boolean canImplicitTypeCast(List<RelDataType> types, List<SqlTypeFamily> families) {
        boolean needed = false;
        if (types.size() != families.size()) {
            return false;
        }
        for (Pair<RelDataType, SqlTypeFamily> pair : Pair.zip(types, families)) {
            RelDataType implicitType = this.implicitCast((RelDataType)pair.left, (SqlTypeFamily)pair.right);
            if (null == implicitType) {
                return false;
            }
            needed = pair.left != implicitType || needed;
        }
        return needed;
    }

    public RelDataType implicitCast(RelDataType in, SqlTypeFamily expected) {
        ImmutableList<SqlTypeFamily> numericFamilies = ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.DECIMAL, SqlTypeFamily.APPROXIMATE_NUMERIC, SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.INTEGER);
        ImmutableList<SqlTypeFamily> dateTimeFamilies = ImmutableList.of(SqlTypeFamily.DATE, SqlTypeFamily.TIME, SqlTypeFamily.TIMESTAMP);
        if (expected.getTypeNames().contains((Object)in.getSqlTypeName())) {
            return in;
        }
        if (SqlTypeUtil.isNull(in)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isNumeric(in) && expected == SqlTypeFamily.DECIMAL) {
            return this.factory.decimalOf(in);
        }
        if (SqlTypeUtil.isApproximateNumeric(in) && expected == SqlTypeFamily.EXACT_NUMERIC) {
            return this.factory.decimalOf(in);
        }
        if (SqlTypeUtil.isDate(in) && expected == SqlTypeFamily.TIMESTAMP) {
            return this.factory.createSqlType(SqlTypeName.TIMESTAMP);
        }
        if (SqlTypeUtil.isTimestamp(in) && expected == SqlTypeFamily.DATE) {
            return this.factory.createSqlType(SqlTypeName.DATE);
        }
        if (SqlTypeUtil.isCharacter(in) && numericFamilies.contains(expected)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isCharacter(in) && dateTimeFamilies.contains(expected)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isCharacter(in) && expected == SqlTypeFamily.BINARY) {
            return expected.getDefaultConcreteType(this.factory);
        }
        if (SqlTypeUtil.isAtomic(in) && (expected == SqlTypeFamily.STRING || expected == SqlTypeFamily.CHARACTER)) {
            return expected.getDefaultConcreteType(this.factory);
        }
        return null;
    }
}

