/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.airlift.slice;

import coral.shading.io.airlift.slice.Preconditions;
import java.lang.reflect.Field;
import java.nio.Buffer;
import sun.misc.Unsafe;

final class JvmUtils {
    static final Unsafe unsafe;
    private static final long ADDRESS_OFFSET;

    private static void assertArrayIndexScale(String name, int actualIndexScale, int expectedIndexScale) {
        if (actualIndexScale != expectedIndexScale) {
            throw new IllegalStateException(name + " array index scale must be " + expectedIndexScale + ", but is " + actualIndexScale);
        }
    }

    static long bufferAddress(Buffer buffer) {
        Preconditions.checkArgument(buffer.isDirect(), "buffer is not direct");
        return unsafe.getLong(buffer, ADDRESS_OFFSET);
    }

    private JvmUtils() {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
            JvmUtils.assertArrayIndexScale("Boolean", Unsafe.ARRAY_BOOLEAN_INDEX_SCALE, 1);
            JvmUtils.assertArrayIndexScale("Byte", Unsafe.ARRAY_BYTE_INDEX_SCALE, 1);
            JvmUtils.assertArrayIndexScale("Short", Unsafe.ARRAY_SHORT_INDEX_SCALE, 2);
            JvmUtils.assertArrayIndexScale("Int", Unsafe.ARRAY_INT_INDEX_SCALE, 4);
            JvmUtils.assertArrayIndexScale("Long", Unsafe.ARRAY_LONG_INDEX_SCALE, 8);
            JvmUtils.assertArrayIndexScale("Float", Unsafe.ARRAY_FLOAT_INDEX_SCALE, 4);
            JvmUtils.assertArrayIndexScale("Double", Unsafe.ARRAY_DOUBLE_INDEX_SCALE, 8);
            ADDRESS_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

