/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.testing;

import coral.shading.com.google.common.base.Joiner;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.SqlFormatter;
import coral.shading.io.trino.sql.parser.ParsingException;
import coral.shading.io.trino.sql.parser.ParsingOptions;
import coral.shading.io.trino.sql.parser.SqlParser;
import coral.shading.io.trino.sql.tree.DefaultTraversalVisitor;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.Statement;
import coral.shading.javax.annotation.Nullable;
import java.util.List;

public final class TreeAssertions {
    private TreeAssertions() {
    }

    public static void assertFormattedSql(SqlParser sqlParser, Node expected) {
        ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE);
        TreeAssertions.assertFormattedSql(sqlParser, parsingOptions, expected);
    }

    public static void assertFormattedSql(SqlParser sqlParser, ParsingOptions parsingOptions, Node expected) {
        String formatted = SqlFormatter.formatSql(expected);
        Statement actual = TreeAssertions.parseFormatted(sqlParser, parsingOptions, formatted, expected);
        TreeAssertions.assertEquals(SqlFormatter.formatSql(actual), formatted);
        if (!actual.equals(expected)) {
            TreeAssertions.assertListEquals(TreeAssertions.linearizeTree(actual), TreeAssertions.linearizeTree(expected));
        }
        TreeAssertions.assertEquals(actual, expected);
    }

    private static Statement parseFormatted(SqlParser sqlParser, ParsingOptions parsingOptions, String sql, Node tree) {
        try {
            return sqlParser.createStatement(sql, parsingOptions);
        }
        catch (ParsingException e) {
            String message = String.format("failed to parse formatted SQL: %s\nerror: %s\ntree: %s", sql, e.getMessage(), tree);
            throw new AssertionError(message, e);
        }
    }

    private static List<Node> linearizeTree(Node tree) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultTraversalVisitor<Void>(){

            @Override
            public Void process(Node node, @Nullable Void context) {
                super.process(node, context);
                nodes.add(node);
                return null;
            }
        }.process(tree, (Void)null);
        return nodes.build();
    }

    private static <T> void assertListEquals(List<T> actual, List<T> expected) {
        if (actual.size() != expected.size()) {
            throw new AssertionError((Object)String.format("Lists not equal in size%n%s", TreeAssertions.formatLists(actual, expected)));
        }
        if (!actual.equals(expected)) {
            throw new AssertionError((Object)String.format("Lists not equal at index %s%n%s", TreeAssertions.differingIndex(actual, expected), TreeAssertions.formatLists(actual, expected)));
        }
    }

    private static <T> String formatLists(List<T> actual, List<T> expected) {
        Joiner joiner = Joiner.on("\n    ");
        return String.format("Actual [%s]:%n    %s%nExpected [%s]:%n    %s%n", actual.size(), joiner.join(actual), expected.size(), joiner.join(expected));
    }

    private static <T> int differingIndex(List<T> actual, List<T> expected) {
        for (int i = 0; i < actual.size(); ++i) {
            if (actual.get(i).equals(expected.get(i))) continue;
            return i;
        }
        return actual.size();
    }

    private static <T> void assertEquals(T actual, T expected) {
        if (!actual.equals(expected)) {
            throw new AssertionError((Object)String.format("expected [%s] but found [%s]", expected, actual));
        }
    }
}

