/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.DataType;
import coral.shading.io.trino.sql.tree.DataTypeParameter;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DateTimeDataType
extends DataType {
    private final Type type;
    private final boolean withTimeZone;
    private final Optional<DataTypeParameter> precision;

    public DateTimeDataType(NodeLocation location, Type type, boolean withTimeZone, Optional<DataTypeParameter> precision) {
        this(Optional.of(location), type, withTimeZone, precision);
    }

    public DateTimeDataType(Optional<NodeLocation> location, Type type, boolean withTimeZone, Optional<DataTypeParameter> precision) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.withTimeZone = withTimeZone;
        this.precision = Objects.requireNonNull(precision, "precision is null");
    }

    public Type getType() {
        return this.type;
    }

    public boolean isWithTimeZone() {
        return this.withTimeZone;
    }

    public Optional<DataTypeParameter> getPrecision() {
        return this.precision;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDateTimeType(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeDataType that = (DateTimeDataType)o;
        return this.withTimeZone == that.withTimeZone && this.type == that.type && this.precision.equals(that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.withTimeZone, this.precision});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!DateTimeDataType.sameClass(this, other)) {
            return false;
        }
        DateTimeDataType otherType = (DateTimeDataType)other;
        return this.type.equals((Object)otherType.type) && this.withTimeZone == otherType.withTimeZone && this.precision.equals(otherType.precision);
    }

    public static enum Type {
        TIMESTAMP,
        TIME;

    }
}

