/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.Preconditions;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Format
extends Expression {
    private final List<Expression> arguments;

    public Format(List<Expression> arguments) {
        this(Optional.empty(), arguments);
    }

    public Format(NodeLocation location, List<Expression> arguments) {
        this(Optional.of(location), arguments);
    }

    private Format(Optional<NodeLocation> location, List<Expression> arguments) {
        super(location);
        Objects.requireNonNull(arguments, "arguments is null");
        Preconditions.checkArgument(arguments.size() >= 2, "must have at least two arguments");
        this.arguments = ImmutableList.copyOf(arguments);
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFormat(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Format o = (Format)obj;
        return Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arguments);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Format.sameClass(this, other);
    }
}

