/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.Preconditions;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.OrderBy;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Window;
import coral.shading.io.trino.sql.tree.WindowReference;
import coral.shading.io.trino.sql.tree.WindowSpecification;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final Optional<Window> window;
    private final Optional<Expression> filter;
    private final Optional<OrderBy> orderBy;
    private final boolean distinct;
    private final Optional<NullTreatment> nullTreatment;
    private final List<Expression> arguments;

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this(Optional.empty(), name, Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), arguments);
    }

    public FunctionCall(NodeLocation location, QualifiedName name, List<Expression> arguments) {
        this(Optional.of(location), name, Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), arguments);
    }

    public FunctionCall(Optional<NodeLocation> location, QualifiedName name, Optional<Window> window, Optional<Expression> filter, Optional<OrderBy> orderBy, boolean distinct, Optional<NullTreatment> nullTreatment, List<Expression> arguments) {
        super(location);
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(window, "window is null");
        window.ifPresent(node -> Preconditions.checkArgument(node instanceof WindowReference || node instanceof WindowSpecification, "unexpected window: " + node.getClass().getSimpleName()));
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(nullTreatment, "nullTreatment is null");
        Objects.requireNonNull(arguments, "arguments is null");
        this.name = name;
        this.window = window;
        this.filter = filter;
        this.orderBy = orderBy;
        this.distinct = distinct;
        this.nullTreatment = nullTreatment;
        this.arguments = arguments;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Optional<Window> getWindow() {
        return this.window;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Optional<NullTreatment> getNullTreatment() {
        return this.nullTreatment;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public Optional<Expression> getFilter() {
        return this.filter;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.window.ifPresent(window -> nodes.add((Node)((Object)window)));
        this.filter.ifPresent(nodes::add);
        this.orderBy.map(OrderBy::getSortItems).ifPresent(nodes::addAll);
        nodes.addAll(this.arguments);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window) && Objects.equals(this.filter, o.filter) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.distinct, o.distinct) && Objects.equals(this.nullTreatment, o.nullTreatment) && Objects.equals(this.arguments, o.arguments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.distinct, this.nullTreatment, this.window, this.filter, this.orderBy, this.arguments);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FunctionCall.sameClass(this, other)) {
            return false;
        }
        FunctionCall otherFunction = (FunctionCall)other;
        return this.name.equals(otherFunction.name) && this.distinct == otherFunction.distinct && this.nullTreatment.equals(otherFunction.nullTreatment);
    }

    public static enum NullTreatment {
        IGNORE,
        RESPECT;

    }
}

