/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.com.google.common.collect.ImmutableSet;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.GrantorSpecification;
import coral.shading.io.trino.sql.tree.Identifier;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.PrincipalSpecification;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class GrantRoles
extends Statement {
    private final Set<Identifier> roles;
    private final Set<PrincipalSpecification> grantees;
    private final boolean adminOption;
    private final Optional<GrantorSpecification> grantor;

    public GrantRoles(NodeLocation location, Set<Identifier> roles, Set<PrincipalSpecification> grantees, boolean adminOption, Optional<GrantorSpecification> grantor) {
        this(Optional.of(location), roles, grantees, adminOption, grantor);
    }

    public GrantRoles(Set<Identifier> roles, Set<PrincipalSpecification> grantees, boolean adminOption, Optional<GrantorSpecification> grantor) {
        this(Optional.empty(), roles, grantees, adminOption, grantor);
    }

    private GrantRoles(Optional<NodeLocation> location, Set<Identifier> roles, Set<PrincipalSpecification> grantees, boolean adminOption, Optional<GrantorSpecification> grantor) {
        super(location);
        this.roles = ImmutableSet.copyOf((Collection)Objects.requireNonNull(roles, "roles is null"));
        this.grantees = ImmutableSet.copyOf((Collection)Objects.requireNonNull(grantees, "grantees is null"));
        this.adminOption = adminOption;
        this.grantor = Objects.requireNonNull(grantor, "grantor is null");
    }

    public Set<Identifier> getRoles() {
        return this.roles;
    }

    public Set<PrincipalSpecification> getGrantees() {
        return this.grantees;
    }

    public boolean isAdminOption() {
        return this.adminOption;
    }

    public Optional<GrantorSpecification> getGrantor() {
        return this.grantor;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGrantRoles(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantRoles grantRoles = (GrantRoles)o;
        return this.adminOption == grantRoles.adminOption && Objects.equals(this.roles, grantRoles.roles) && Objects.equals(this.grantees, grantRoles.grantees) && Objects.equals(this.grantor, grantRoles.grantor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.roles, this.grantees, this.adminOption, this.grantor);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("roles", this.roles).add("grantees", this.grantees).add("adminOption", this.adminOption).add("grantor", this.grantor).toString();
    }
}

