/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.SelectItem;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Select
extends Node {
    private final boolean distinct;
    private final List<SelectItem> selectItems;

    public Select(boolean distinct, List<SelectItem> selectItems) {
        this(Optional.empty(), distinct, selectItems);
    }

    public Select(NodeLocation location, boolean distinct, List<SelectItem> selectItems) {
        this(Optional.of(location), distinct, selectItems);
    }

    private Select(Optional<NodeLocation> location, boolean distinct, List<SelectItem> selectItems) {
        super(location);
        this.distinct = distinct;
        this.selectItems = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectItems, "selectItems"));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSelect(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.selectItems;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("distinct", this.distinct).add("selectItems", this.selectItems).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return this.distinct == select.distinct && Objects.equals(this.selectItems, select.selectItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinct, this.selectItems);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Select.sameClass(this, other)) {
            return false;
        }
        return this.distinct == ((Select)other).distinct;
    }
}

