/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.datalake.store;

import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLFileOutputStream;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.ADLStoreClient;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.Core;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.IfExists;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.OperationResponse;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.RequestOptions;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.SyncFlag;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicy;
import io.trino.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.NonIdempotentRetryPolicy;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Utils {
    private ADLStoreClient client;

    Utils(ADLStoreClient client) {
        this.client = client;
    }

    public void upload(String filename, String localFilename, IfExists mode) throws IOException {
        if (localFilename == null || localFilename.trim().equals("")) {
            throw new IllegalArgumentException("localFilename cannot be null");
        }
        try (FileInputStream in = new FileInputStream(localFilename);){
            this.upload(filename, in, mode);
        }
    }

    public void upload(String filename, InputStream in, IfExists mode) throws IOException {
        if (filename == null || filename.trim().equals("")) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        try (ADLFileOutputStream out = this.client.createFile(filename, mode);){
            int n;
            int bufSize = 4000000;
            out.setBufferSize(bufSize);
            byte[] buffer = new byte[bufSize];
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        in.close();
    }

    public void upload(String filename, byte[] contents, IfExists mode) throws IOException {
        if (filename == null || filename.trim().equals("")) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (contents.length <= 0x400000) {
            boolean overwrite = mode == IfExists.OVERWRITE;
            RequestOptions opts = new RequestOptions();
            opts.retryPolicy = overwrite ? new ExponentialBackoffPolicy() : new NonIdempotentRetryPolicy();
            OperationResponse resp = new OperationResponse();
            Core.create(filename, overwrite, null, contents, 0, contents.length, null, null, true, SyncFlag.CLOSE, this.client, opts, resp);
            if (!resp.successful) {
                throw this.client.getExceptionFromResponse(resp, "Error creating file " + filename);
            }
        } else {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(contents);){
                this.upload(filename, bis, mode);
            }
        }
    }
}

